https://ui.adsabs.harvard.edu/abs/2018MNRAS.480.3898N/abstract
https://ui.adsabs.harvard.edu/abs/2018MNRAS.480.4468R/abstract


# CL_1ES_1927p654

## Pre-requisites

Install [Julia](https://julialang.org/downloads/) (version > 1.5), and prepare the `AT2018zf` directory with spectral data.


## Installation

```
git clone https://www.ict.inaf.it/gitlab/giorgio.calderone/cl_1es_1927p654
cd cl_1es_1927p654
```

Start Julia, then:
```julia
using Pkg
Pkg.activate(".")
Pkg.instantiate()
```

## Update
The analysis code can be updated with:
```
cd cl_1es_1927p654
git pull
```

Then, in Julia:
```julia
using Pkg
Pkg.activate(".")
Pkg.update()
```


## Usage

### Load packages and read spectrum file names (one for each epoch):
```julia
using Pkg
Pkg.activate(".")

using Revise
using QSFit, GFit, Gnuplot, GFitViewer
using CL_1ES_1927p654

epochs = Vector{String}()
for (root, dirs, files) in walkdir("AT2018zf")
    for file in files
        if file[end-3:end] == ".dat"
            push!(epochs, root * "/" * file)
        end
    end
end
```


### Plot spectrum at all epochs
([gnuplot](http://www.gnuplot.info/) is required to display the plot)

```julia
@gp ylog=true xr=[3e3,1e4] yr=[1e-16, 1e-13] cbr=[1,26] :-
@gp :- cblabel="Epoch" xlab="Rest frame wavelength[A]" ylab="Flux density"
for ii in 1:length(epochs)
    file = epochs[ii]
    println(file)
    l = readlines(file)
    @gp :- l "u (\$1/1.017):2:($ii) w l notit lc pal"
    #(readline() == "q")  &&  break
end
```

### Run analysis on a specific epoch
```julia
chosen_epoch = 17
file = epochs[chosen_epoch]
source = QSO{q1927p654}("1ES 1927+654 ($chosen_epoch)", 0.019422, ebv=0.077);
source.options[:min_spectral_coverage][:OIII_5007] = 0.5
# source.options[:host_template] = "/home/gcalderone/Mbi1.30Zm1.49T00.0700_iTp0.00_baseFe_linear_FWHM_2.51"
add_spec!(source, Spectrum(Val(:ASCII), file, columns=[1,2]));
source.data[1].val .*= 1e17;
source.data[1].unc .= 0.05 .* source.data[1].val;
(model, bestfit) = fit(source);
viewer(model, source.data, bestfit, selcomps=[:qso_cont, :galaxy, :balmer])
```

### Multiepoch analysis
```julia
source = QSO{q1927p654}("1ES 1927+654", 0.019422, ebv=0.077);
source.options[:min_spectral_coverage][:OIII_5007] = 0.5
add_spec!(source, Spectrum(Val(:ASCII), "AT2018zf/AT2018zf_optspec_20180716.dat", columns=[1,2]));
add_spec!(source, Spectrum(Val(:ASCII), "AT2018zf/AT2018zf_optspec_20180528.dat", columns=[1,2]));
add_spec!(source, Spectrum(Val(:ASCII), "AT2018zf/AT2018zf_optspec_20180812.dat", columns=[1,2]));
add_spec!(source, Spectrum(Val(:ASCII), "AT2018zf/AT2018zf_optspec_20181113.dat", columns=[1,2]));
for id in 1:length(source.domain)
    source.data[id].val .*= 1e17;
    source.data[id].unc .= 0.05 .* source.data[id].val;
end
(model, bestfit) = multi_fit(source);
viewer(model, source.data, bestfit, selcomps=[:qso_cont, :galaxy, :balmer])
```


## Analysis recipes

The default QSFit analysis recipes are implemented here:
- [single epoch](https://github.com/gcalderone/QSFit.jl/blob/master/src/DefaultRecipe.jl)
- [multi epoch](https://github.com/gcalderone/QSFit.jl/blob/master/src/DefaultRecipe_multi.jl)

This package implements a custom recipe named `q1927p654` whose code is available in `src/CL_1ES_1927p654.jl`.
