import pandas as pd
from optparse import OptionParser
import json

def readMethodsSheet(icdfile):
    try:
        meths = pd.read_excel(icdfile,sheet_name="Methods")
        return meths
    except FileNotFoundError:
        print("File does not exist")
        return None

def getNumOfMeth(meths):
    return meths.shape

def checkArray(s):
    #s="Double[5]"
    ini=s.find('[')
    #print(ini)
    if ini> 0:
        fin=s.find(']')
        dim=s[ini+1:fin]
        ty=s.split('[')[0].upper()
        isArr=1
    else:
        isArr=-1
        ty=s.upper()
        dim=""
    #print(isArr,ty,dim)
    return isArr,ty,dim

def getInOutArg(el):
    s=el.split(',')
    #print(s)
    ele={}
    if len(s)==3:
        ele["name"]=s[0]
        ele["desc"]=s[1]
        isArr,ty,dim=checkArray(s[2])
        ele["isArray"]=isArr
        ele["dtype"]=ty
        ele["ArrayDim"]=dim
        #ele["NodeId"]={'ns':s[3].split(';')[0],'i':s[3].split(';')[1]}
        return ele
    else:
        return None

def printDict(dct):
    print(json.dumps(dct, sort_keys=False, indent=4))

def getMetArgs(args):
    Args=[]
    a=args.split(':')
    #print(a)
    for el in a:
        #print(el)
        ele=getInOutArg(el)
        #print(ele)
        if ele is not None:
            Args.append(ele)
    return Args

def scanMeth(meth):
    method={}
    method["AcsFunName"]=meth["Name of command"].upper()
    method["OpcUaMethName"]=meth["MethodName"]
    tm=meth["MethodName_NodeId"]
    method["OpcUaMethNodeId"]={'ns':tm.split(';')[0],'i':tm.split(';')[1]}
    tm=meth["InputArgs_NodeId"]
    method["Input"]={'NodeId':{'ns':tm.split(';')[0],'i':tm.split(';')[1]},'Args':getMetArgs(meth["InputArgs"])}
    tm=meth["OutArgs_NodeId"]
    method["Output"]={'NodeId':{'ns':tm.split(';')[0],'i':tm.split(';')[1]},'Args':getMetArgs(meth["OutArgs"])}
    method["Desc"]=meth["Description"]
    return method

def selectMetDevice(sheet,device):
    if device==None:
        return sheet
    else:
        return sheet.loc[sheet['Device Name'] == device]

def getMethods(method,device=None):
    meth=[]
    methods={}
    try:
        meths=selectMetDevice(method,device)
        nm=getNumOfMeth(meths)
        #printDict(meths.loc[2].to_dict())
        print("The file include:",nm[0]," Methods")
        for i  in range(0,nm[0]):
            met=scanMeth(meths.iloc[i].to_dict())
            meth.append(met)
        if device ==None:
            methods["Device"]="ALL"
        else:
            methods["Device"]=device
        methods["NumMethods"]=nm[0]
        methods["Methods"]=meth
        return methods
    except:
        print("Error occurred reading/analyzing File ")
        return None

def main():
    usage = "usage: %prog [options] arg"
    parser = OptionParser(usage)
    parser.add_option("-f", "--file", dest="filename", default=None,
                      help="read data from excel FILENAME")
    parser.add_option("-d", "--device", dest="device", default=None,
                      help="read data for a specific device of an Assembly")
    (options, args) = parser.parse_args()
    icdfile=options.filename
    if icdfile is None:
         parser.print_help()
         exit(1)
    meths=readMethodsSheet(icdfile)
    if options.device is not None:
        device=options.device.upper()
        methods=getMethods(meths,device)
    else:
        methods=getMethods(meths)
    if methods is not None:
        printDict(methods)
        #print(met)

if __name__ == '__main__':

    main()
