from Cheetah.Template import Template
from datetime import date
import sys,os
from optparse import OptionParser
from readMeth import *
import openpyxl.utils.exceptions as ecc
from GenDevice.excelIcd import excelIcd

DEF_DEST ="."
gen_dir=os.environ["PYGEN"]
if gen_dir==None:
    print("PYGEN variable is not set")
    os.exit(0)

def createOPCUModel(book,dest,ns):
    wb=excelIcd(book)
    Main=wb.MainSheet
    Get=wb.GetSheet
    Set=wb.SetSheet
    Cmd=wb.CmdSheet
    Mode=wb.ModeSheet
    device=Main['Device Name'][0]
    hasMeth=False
    print("Working on:",Main['Assembly'][0])

    if wb.MethodsSheet is not None:
        methods=getMethods(wb.MethodsSheet,device)
        # printDict(methods)
        hasMeth=True
    today = date.today()
    outfile=dest+"/"+Main['Assembly'][0]+'_ServerModel.xml'
    #print(today,outfile)
    name_space = {'Author': "Gino Tosti",
            "Date":today.strftime("%y/%m/%d"),
    		'Description':Main["Description"][0],
    		'Assembly': Main['Assembly'][0],
            'Url':Main['OPC UA address'][0],
            'Model':os.path.abspath(outfile),
    		'x': Get,
            'y':Set,
            'z':Main,
            'c':Cmd,
            'm':Mode,
            'ns':ns,
            'hasMet':False}
    if hasMeth:
        name_space['Met']=methods
        name_space['hasMet']=True

    template_file=gen_dir+"/templates/simpleServerModel1.tmpl"
    t1 = Template(file=template_file, searchList=[name_space])
    ff=open(outfile,"w")
    ff.write(str(t1))
    print("File:",outfile," created")



def main():
    defdest=DEF_DEST
    parser = OptionParser(usage='usage: %prog [options] arguments')
    parser.add_option("-f", "--file", dest="book_file", default=None,
            help="ICD Exel File ", metavar="FILE")
    parser.add_option("-o", "--outdir", dest="outdir", default="./SimulationOPCUAserver",
                  help="outputdir will be  /SimulationOPCUAserver/ ", metavar="OUTDIR")
    parser.add_option("-n", "--ns", dest="ns", default=4,
                  help="namespace ", metavar="OUTDIR")
    (options, args) = parser.parse_args()
    if not options.book_file:   # if filename is not given
        parser.error('ICD file not given')
    if options.outdir!=None :
        defdest=options.outdir
    if not os.path.exists(defdest):
        os.mkdir(defdest)
        print("Directory " , defdest ,  " Created ")
    else:
        print("Directory " , defdest ,  " already exists")
	#gen_dir=os.environ["PYGEN"]
    ns="2"
    ns=options.ns
    print(type(ns),ns)
    createOPCUModel(options.book_file,os.path.abspath(defdest),ns)
    #print(met)

if __name__ == '__main__':

    main()
