
from optparse import OptionParser
import pandas as pd
import json

TMPFILE='/tmp/tmp_123.docx'
template_file="ASTRI-INAF-ICD-Template.docx"
args={}
def readIcd(icdfile,sheet_name):
    try:
            main_sheet = pd.read_excel(icdfile,sheet_name=sheet_name)
    except FileNotFoundError:
        print("File does not exist")
        return None
    #print(main)
    #print(sheetT)
    return main_sheet.dropna(axis=0,how='all')

def main():
    usage = "usage: %prog [options] arg"
    parser = OptionParser(usage)
    parser.add_option("-f", "--file", dest="filename",
                      help="read data from excel FILENAME")
    parser.add_option("-s", "--sheet", dest="sheet", default=None,
                      help="read a specific sheet")

    (options, args) = parser.parse_args()
    icdfile=options.filename
    she=options.sheet
    sheet=readIcd(icdfile, she)
    if sheet is not None:
        # print (sheet.columns)
        res=sheet.to_json(orient="records")
        parsed = json.loads(res)
        print(json.dumps(parsed, indent=4))
    else:
        print("Error occurred during File generation")
        exit()

if __name__ == '__main__':

    main()
