from Cheetah.Template import Template
from datetime import date
import sys,os
from optparse import OptionParser
from GenDevice.excelIcd import excelIcd
from shutil import copyfile
# Read the ICD excel file
DEF_DEST ="../test/TCL"

def _createinitpy(dest):
	fileout=dest+"/__init__.py"
	if os.path.exists(fileout):
	   print(fileout+" alredy exists")
	else:
	   templ="../template/initpy.tmpl"
	   copyfile(templ,fileout)
	   print("file:"+fileout+" created")
def createTCLScript(book,dest):
	
	excel_file =book
	wb=excelIcd(excel_file)
	Main=wb.getMain()
	Get=wb.getSheet("GET")
	Set=wb.getSheet("SET")
	Cmd=wb.getSheet("CMD")
	Mode=wb.getSheet("MODE")
	print(Main['Assembly'])
	outfile=dest+"/"+Main['Assembly'][0]+'Base.py'
	name_space = {'Author': "Gino Tosti", "Date":today.strftime("%y/%m/%d"),
		'Description':Main["Description"][0],
		'Filename': outfile,
		'Assembly': Main['Assembly'][0],
		'x': Get,'y':Set,'z':Main,'c':Cmd,'m':Mode}
	
	
	template_file="../template/TCLBaseDevice.tmpl"
	t1 = Template(file=template_file, searchList=[name_space])
	ff=open(outfile,"w")
	ff.write(str(t1))
	print(t1)
	print("File:",outfile," created")
	_createinitpy(dest)

if __name__=="__main__":
	defdest=DEF_DEST
	parser = OptionParser(usage='usage: %prog [options] arguments')
	today = date.today()
	parser.add_option("-f", "--file", dest="book_file", default=None,
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-o", "--outdir", dest="outdir", default=None,
                  help="outputdir will be outdir/TCL/ ", metavar="OUTDIR")	  
	(options, args) = parser.parse_args()
	if not options.book_file:   # if filename is not given
		parser.error('ICD file not given')
	if options.outdir!=None :
		defdest=outdir+"/TCL"
	#gen_dir=os.environ["PYGEN"]
	createTCLScript(options.book_file,defdest)
	
