#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
#from getSheets import myIcd
from GenDevice.excelIcd import excelIcd
import sys,os
from optparse import OptionParser
import subprocess
from GenDevice.genFromTemplates import genFromTemplates
from GenDevice.createEmptyCDB import *
from GenDevice.acsUtils import *

if __name__ =="__main__":
	parser = OptionParser()
	today = date.today()
	parser.add_option("-f", "--file", dest="bookfile",
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-d", "--dir", dest="basedir", default="./tmp",
                  help="Root dir where to install the new device ", metavar="DIR")
	parser.add_option("-p", "--prefix", dest="prefix", default="astri",
                  help="pkg prefix es. astri ", metavar="PREFIX")
	parser.add_option("-m", "--module", dest="module", default="tcs",
                  help="module name es.tcs ", metavar="MODULE")
	parser.add_option("-i", "--install", action="store_true",
                  help="execute the Makefile in src dir ", metavar="INSTALL")
	(options, args) = parser.parse_args()
	print("running genDevice with the following options:\n", options)
	#exit()
	gendir=os.environ["PYGEN"]
	if gendir=="":
		print ("Please set the env variable PYGEN = the Geneartor root directory")
		exit()  
	if  not checkACS():
		print ("ACS Enviroment is not set")
		exit()
	pwd=os.getcwd()
	mygen=genFromTemplates(options.bookfile, options.prefix,options.module,options.basedir)
	mygen.generateFileInDir()
	
	if options.install :
	  introot = os.environ["INTROOT"]
	  if introot=="":
	        print("INTROOT variable is not set")
	        exit()
	  os.chdir(mygen._dirs['src'])
	  print ("Make Build ")
	  command="make clean all"
	  print (command)
	  if execACSCommand(command):
	        print ("ERROR executing: ",command,) 
	  """else:
	    command ="make install"
	    if execACSCommand(command):
	       print ("ERROR executing: ",command)
	       os.chdir(pwd)
	       exit()
	  os.chdir(pwd)
	  
	  command="cdbChecker"
	  if execACSCommand(command):
	    print ("ERROR executing: ",command)
	    exit()"""
	print ("ALL Done")
		
	
