from Cheetah.Template import Template
from datetime import date
import sys,os
from optparse import OptionParser
from GenDevice.excelIcd import excelIcd
# Read the ICD excel file



if __name__=="__main__":
	
	parser = OptionParser()
	today = date.today()
	parser.add_option("-f", "--file", dest="book_file",
                  help="ICD Exel File ", metavar="FILE")
		  
	parser.add_option("-d", "--database", dest="database", default="testgen",
                  help="Main Database to be used ", metavar="DB")

	parser.add_option("-b", "--baselelement", dest="base_element", default="Telescope",
                  help="BaseElement of the Assembly ", metavar="BE")

	(options, args) = parser.parse_args()
	gen_dir=os.environ["PYGEN"]
	excel_file =options.book_file
	wb=excelIcd(excel_file)
	Main=wb.getMain()
	Get=wb.getSheet("GET")
	Set=wb.getSheet("SET")
	
	outfile='AddSQL_'+Main['Assembly'][0]+'.sql'
	name_space = {'Author': "Gino Tosti", "Date":today.strftime("%y/%m/%d"),
		'Description':Main["Description"][0],
		'Filename': outfile,
		'Database': options.database,
		'BaseElement': options.base_element,
		'x': Get,'y':Set,'z':Main}
	
	
	template_file="AddSQLDevice.tmpl"
	t1 = Template(file=template_file, searchList=[name_space])
	ff=open(outfile,"w")
	ff.write(str(t1))
	print(t1)
	print("File:",outfile," created")
