#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
import sys,os
from optparse import OptionParser
from GenDevice.excelIcd import excelIcd
from shutil import copyfile
# Read the ICD excel file
DEF_DEST ="."
gen_dir=os.environ["PYGEN"]
if gen_dir==None:
	print("PYGEN variable is not set")
	os.exit(0)

def createOPCUModel(book,dest,ns):
	
	excel_file =book
	wb=excelIcd(excel_file)
	Main=wb.getSheet("Main")
	Get=wb.getSheet("GET")
	Set=wb.getSheet("SET")
	Cmd=wb.getSheet("CMD")
	Mode=wb.getSheet("MODE")
	print("Working on:",Main['Assembly'])
	today = date.today()
	outfile=dest+"/"+Main['Assembly'][0]+'_ServerModel.xml'
	scriptfile=dest+"/"+Main['Assembly'][0]+'_opcuaServer.py'
	name_space = {'Author': "Gino Tosti", "Date":today.strftime("%y/%m/%d"),
		'Description':Main["Description"][0],
		'Assembly': Main['Assembly'][0], 'Url':Main['OPC UA address'][0],'Model':os.path.abspath(outfile),
		'x': Get,'y':Set,'z':Main,'c':Cmd,'m':Mode,'ns':ns}
	
	
	template_file=gen_dir+"/templates/simpleServerModel.tmpl"
	t1 = Template(file=template_file, searchList=[name_space])
	ff=open(outfile,"w")
	ff.write(str(t1))
	#print(t1)
	print("File:",outfile," created")
	template_file=gen_dir+"/templates/minserver.tmpl"
	t2 = Template(file=template_file, searchList=[name_space])
	ff=open(scriptfile,"w")
	ff.write(str(t2))
	#print(t2)
	print("File:",scriptfile," created")
	print("The Simulation server can be reached at:",name_space['Url'])


if __name__=="__main__":
	defdest=DEF_DEST
	parser = OptionParser(usage='usage: %prog [options] arguments')
	parser.add_option("-f", "--file", dest="book_file", default=None,
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-o", "--outdir", dest="outdir", default="./SimulationOPCUAserver",
                  help="outputdir will be  /SimulationOPCUAserver/ ", metavar="OUTDIR")	
	parser.add_option("-n", "--ns", dest="ns", default=4,
                  help="namespace ", metavar="OUTDIR")	  
	(options, args) = parser.parse_args()
	if not options.book_file:   # if filename is not given
		parser.error('ICD file not given')
	if options.outdir!=None :
		defdest=options.outdir
	if not os.path.exists(defdest):
    		os.mkdir(defdest)
    		print("Directory " , defdest ,  " Created ")
	else:    
		print("Directory " , defdest ,  " already exists")	
	#gen_dir=os.environ["PYGEN"]
	ns=""
	ns=options.ns
	print(type(ns),ns)
	createOPCUModel(options.book_file,os.path.abspath(defdest),ns)
	
