from Cheetah.Template import Template
from datetime import date
import sys,os
from optparse import OptionParser
from GenDevice.excelIcd import excelIcd
from GenDevice.genFromTemplates import datatype
from shutil import copyfile
# Read the ICD excel file
DEF_DEST ="../test/gui"
TMPL_DIR="../templates/guiTmpl/"
TMPL=["Makefile1.tmpl","GUIBridge1.tmpl",
"GUIBridgeComponent1.tmpl",
"GUIBridgeController1.tmpl",
"GUIMainApp1.tmpl"]
 
def createGUIScript(book,dest):
	
	excel_file =book
	wb=excelIcd(excel_file)
	Main=wb.getMain()
	Get=wb.getSheet("GET")
	Set=wb.getSheet("SET")
	Cmd=wb.getSheet("CMD")
	Mode=wb.getSheet("MODE")
	print(Main['Assembly'])

	if not os.path.exists(dest):
		os.mkdir(dest)
	#'Filename': outfile,
	name_space = {'Author': "Gino Tosti", "Date":today.strftime("%y/%m/%d"),
			'Description':Main["Description"][0],
			'Assembly': Main['Assembly'][0],
			'x': wb, 'y':datatype}
	for i,tp in enumerate(TMPL):
		if i==1:
			outfile=dest+"/"+Main['Assembly'][0]+"_"+ tp.replace("1.tmpl",".fxml")
		elif i==0:
			outfile=dest+"/"+ tp.replace("1.tmpl","")
		else:
			outfile=dest+"/"+Main['Assembly'][0]+"_"+ tp.replace("1.tmpl",".java")
		template_file=TMPL_DIR+tp
		
		
		t1 = Template(file=template_file, searchList=[name_space])
		ff=open(outfile,"w")
		ff.write(str(t1))
		#print(t1)
		print("File:",outfile," created")

if __name__=="__main__":
	defdest=DEF_DEST
	parser = OptionParser(usage='usage: %prog [options] arguments')
	today = date.today()
	parser.add_option("-f", "--file", dest="book_file", default=None,
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-o", "--outdir", dest="outdir", default=None,
                  help="outputdir will be outdir/gui/ ", metavar="OUTDIR")	  
	(options, args) = parser.parse_args()
	if not options.book_file:   # if filename is not given
		parser.error('ICD file not given')
	if options.outdir!=None :
		defdest=outdir+"/gui"
	#gen_dir=os.environ["PYGEN"]
	createGUIScript(options.book_file,defdest)
	
