from GenDevice.acsUtils import *
import shutil
import os
managerxml="""<?xml version="1.0" encoding="ISO-8859-1"?>
<Manager   xmlns:cdb="urn:schemas-cosylab-com:CDB:1.0" 
           xmlns="urn:schemas-cosylab-com:Manager:1.0" 
           xmlns:log="urn:schemas-cosylab-com:LoggingConfig:1.0"
           xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
     Timeout="50.0"
     ClientPingInterval="10.0"
     ContainerPingInterval="10.0"
     AdministratorPingInterval="10.0">
	
	<Startup>
	</Startup>

	<ServiceComponents>
		<cdb:e string="AcsAlarmService" />
		<cdb:e string="ACSLogSvc" />
		<cdb:e string="Log" />
		<cdb:e string="LogFactory" />
		<cdb:e string="NotifyEventChannelFactory" />
		<cdb:e string="LoggingNotifyEventChannelFactory" />
		<cdb:e string="AlarmNotifyEventChannelFactory" />
		<cdb:e string="AlarmChannel" />
		<cdb:e string="InterfaceRepository" />
		<cdb:e string="CDB" />
	</ServiceComponents>

	<LoggingConfig>
		<log:e Name="jacorb@Manager" minLogLevel="5" minLogLevelLocal="4" />
	</LoggingConfig>

</Manager>
 """
javacontXml = """<?xml version="1.0" encoding="ISO-8859-1"?>
<Container 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns="urn:schemas-cosylab-com:Container:1.0" 
	xmlns:log="urn:schemas-cosylab-com:LoggingConfig:1.0" 
	ImplLang="java"
        ServerThreads="99"
	>

	<Autoload>
	</Autoload>

	<LoggingConfig 
           centralizedLogger="Log" 
           minLogLevel="4" 
           dispatchPacketSize="10" 
           immediateDispatchLevel="99">
           <log:e Name="jacorb@frodoContainer"
		minLogLevel="8" minLogLevelLocal="8" />
	   <log:e Name="UnknownSlf4j@frodoContainer"
		minLogLevel="8" minLogLevelLocal="8" />
        </LoggingConfig>

</Container>
 """


def setCDBEnvVar(dirname):
	os.environ["ACS_CDB"]=dirname
	pwd = os.getcwd()
	os.chdir(dirname)
	f=open("setCDB.sh","w")
	f.write("export ACS_CDB="+dirname+"\n")
	f.close()
	os.chdir(pwd)
	return



def createDir(dirname):
	command="mkdir -p "
	# print("******createDir-->"+dirname)
	if dirname !="":
		if os.path.exists(dirname):
			print ("dir:",dirname," already exists")
			return False
		else:
			command=command+dirname
			# print (command)
			execACSCommand(command)

	else:
		print ("A null dirname was inserted")
		return False
	return True

def createCBDBaseDir(dirname):
	if createDir(dirname):
	  print ("CDB base dir created")
	  return True
	else:
	  # print ("error")
	  return False

def createCDBDirs():
	basedir=os.environ["ACS_CDB"]
	templatedir=os.environ["PYGEN"]+ "/templates/CDB" #/templates/Alarms"
	print (basedir)
	if basedir=="":
	   print ("ACS_CDB variable is not defined")
	   return False
	else:
		alarmdir=basedir+"/CDB"    #"/CDB/Alarms"
		if os.path.exists(alarmdir):
			print ("dir:",alarmdir," already exists")
		else:
			shutil.copytree(templatedir,alarmdir)
		"""almadir = basedir+"/CDB/alma"
		if createDir(almadir):
			srt="directory:"+almadir+" created"
			print (srt)
		else: 
			print ("error creting directory:",almadir)
		schemadir = basedir+"/CDB/schemas"
		if createDir(schemadir):
			print ("directory:"+schemadir+" created")
		else: 
			print ("error creting directory:"+schemadir)
		macidir = basedir +"/CDB/MACI/{Components,Containers,Managers}"
		if createDir(macidir):
			print ("directory:"+macidir+" created")
		else: 
			print ("error creting directory:"+macidir)

		managerdir = basedir+"/CDB/MACI/Managers/Manager"
		if createDir(managerdir):
			print ("directory:"+managerdir+" created")
		else: 
			print ("error creting directory:"+managerdir)"""
			   
def createManagerXml():
	basedir=os.environ["ACS_CDB"]
	managerdir = basedir+"/CDB/MACI/Managers/Manager"
	managerfile=managerdir+"/Manager.xml"
	f = open(managerfile,"w")
	f.write(managerxml)
	f.close()

def createJavaContXml(name):
	basedir=os.environ["ACS_CDB"]
	javacontdir = basedir +"/CDB/MACI/Containers/"+name
	if createDir(javacontdir):
		print ("directory:"+javacontdir+" created")
	else: 
		# print ("error creating directory:"+javacontdir)
		return False
	javacontfile=javacontdir+"/"+name+".xml"
	f = open(javacontfile,"w")
	f.write(javacontXml)
	f.close()

if __name__=="__main__":
	createCBDBaseDir(sys.argv[1])
	setCDBEnvVar(sys.argv[1])
	createCDBDirs()
	createManagerXml()
	createJavaContXml()
