#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
#from getSheets import myIcd
from GenDevice.excelIcd import excelIcd
import sys,os
from optparse import OptionParser
import subprocess
from GenDevice.genFromTemplates import genFromTemplates
from GenDevice.createEmptyCDB import *
from GenDevice.acsUtils import *
import pandas as pd

if __name__ =="__main__":
	parser = OptionParser()
	today = date.today()
	parser.add_option("-f", "--file", dest="bookfile",
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-d", "--dir", dest="basedir", default="./tmp",
                  help="Root dir where to install the new device ", metavar="DIR")
	parser.add_option("-p", "--prefix", dest="prefix", default="astri",
                  help="pkg prefix es. astri ", metavar="PREFIX")
	parser.add_option("-m", "--module", dest="module", default="tcs",
                  help="module name es.tcs ", metavar="MODULE")
	parser.add_option("-i", "--install", action="store_true",
                  help="execute the Makefile in src dir ", metavar="INSTALL")
	(options, args) = parser.parse_args()
	print("running genDevice with the following options:\n", options)
	#exit()
	gendir=os.environ["PYGEN"]
	if gendir=="":
		print ("Please set the env variable PYGEN = the Geneartor root directory")
		exit()  
	if  not checkACS():
		print ("ACS Enviroment is not set")
		exit()
	pwd=os.getcwd()
	excel_file =options.bookfile
	wb=excelIcd(excel_file)
	devs=wb.MainSheet['Device Name']
	comp=wb.MainSheet['Component Name']
	assembly=wb.MainSheet['Assembly']
	outdir="/media/sf_Desktop/Useful_SW/"
	outfile=[]
	if len(assembly)>1 :
		print ("the Assembly:"+assembly[0]+" includes more than one device\n",devs)
		for dev in devs:
			print("working On device:", dev)
			query="`Device Name` =="+ "'"+dev+"'"
			main=(wb.book.parse("Main")).query(query)
			get=(wb.book.parse("GET")).query(query)
			sett=(wb.book.parse("SET")).query(query)
			cmd=(wb.book.parse("CMD")).query(query)
			mode=(wb.book.parse("MODE")).query(query)
			outfile.append(outdir+dev+".xlsx")
			with pd.ExcelWriter(outfile[-1]) as writer:
				main.to_excel(writer,sheet_name='Main')
				get.to_excel(writer,sheet_name='GET')
				sett.to_excel(writer,sheet_name='SET')
				cmd.to_excel(writer,sheet_name='CMD')
				mode.to_excel(writer,sheet_name='MODE')
			print("Working on files:",dev)
			mygen=genFromTemplates(outfile[-1],options.prefix,options.module,options.basedir)
			mygen.generateFileInDir()
			if options.install :
			  introot = os.environ["INTROOT"]
			  if introot=="":
			     print("INTROOT variable is not set")
			  else:
			     os.chdir(mygen._dirs['src'])
			     print ("Make Build ")
			     command="make clean all"
			     print (command)
			     if execACSCommand(command):
			        print ("ERROR executing: ",command) 
			     os.chdir(pwd)
	else:
		print ("the Assembly:"+assembly[0]+" includes one device\n",devs)
		mygen=genFromTemplates(options.bookfile,options.prefix,options.module,options.basedir)
		mygen.generateFileInDir()
		if options.install :
		  introot = os.environ["INTROOT"]
		  if introot=="":
		     print("INTROOT variable is not set")
		  else:
		     os.chdir(mygen._dirs['src'])
		     print ("Make Build ")
		     command="make clean all"
		     print (command)
		     if execACSCommand(command):
		        print ("ERROR executing: ",command) 
		     os.chdir(pwd)
	print ("ALL Done")
		
	
