#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
from GenDevice.excelIcd import excelIcd
import sys,os
from optparse import OptionParser
import subprocess
from GenDevice.genFromTemplates import genFromTemplates
from GenDevice.createEmptyCDB import *
from GenDevice.acsUtils import *

import PySimpleGUI as sg

fnt = 'Arial 18'

def warningWin(txt):
	event, values = sg.Window('*****Warning****',
                  [[sg.Text(txt)],
                  [sg.B('OK'), sg.B('Cancel') ]], size=(400,200),font=fnt ).read(close=True)
	return (event, values)

def generateFiles(opt):
	mygen=genFromTemplates(opt['bookfile'], opt['prefix'],opt['module'],opt['basedir'])
	if mygen.checkIfExists():
		txt="The device files already exists in:\n"+str(mygen.outdir)+"\nOverride existing files?"
		event, value=warningWin(txt)
		if event == 'OK':
			mygen.generateFileInDir()
			return mygen._dirs
		else:
			return None
	else:
		mygen.generateFileInDir()
		return mygen._dirs

def buildCode(dirs):
	pwd=os.getcwd()
	os.chdir(dirs['src'])
	print ("Make Build ")
	command="make clean all"
	print ("Execuiting:",command)
	if execACSCommand(command):
		print ("ERROR executing: ",command,) 
	os.chdir(pwd)	

def readOptions(window,values):
	opt={}
	if not values['-IN-']=="":
		opt['bookfile']=values['-IN-']
	else:
		event, value=warningWin("Input file is not set")
		return None
	if not values['-OUT-']=="":
		opt['basedir']=values['-OUT-']
	else:
		event, value=warningWin("Output dir is not set by user\nDefault value is : ./tmp")
		if event == 'OK':
			opt['basedir']="./tmp"
			window['-OUT-'].update(opt['basedir'])
			window.Refresh()
		else:
			return None
	if not values['-PACK-']=="":
		opt['prefix']=values['-PACK-']
	else:
		event, value=warningWin("Package name set by user.\nDefault value is: astri")
		if event == 'OK':
			opt['prefix']="astri"
			window['-PACK-'].update(opt['prefix'])
			window.Refresh()
		else:
			return None
	if not values['-MOD-']=="":
		opt['module']=values['-MOD-']
	else:
		event, value=warningWin("Module name set by user.\nDefault value is: tcs")
		if event == 'OK':
			opt['module']="tcs"
			window['-MOD-'].update(opt['module'])
			window.Refresh()
		else:
			return None
	return opt
	
def myLayout():
	
	sg.theme('DarkTeal12')    # Keep things interesting for your users

	layout = [[sg.T('Set Input Parameters')],      
          [sg.T('input ICD file',size=(15,1)),sg.I(key='-IN-', size=(60,1),), sg.Button('BrowseFile')], [sg.T('Output Dir',size=(15,1)),      
          sg.I(key='-OUT-',size=(60,1)), sg.Button('BrowseDir')], [sg.T('Package Prefix',size=(15,1))      
          ,sg.I("astri",key='-PACK-',size=(20,1))], [sg.Text('Module Prefix',size=(15,1)),      
          sg.Input("tcs",key='-MOD-',size=(20,1))],
          [sg.Button('Submit'), sg.Button('Generate'), sg.Button('Build'), sg.Exit()],
	  [sg.MLine(key='-ML-', size=(80,20),reroute_stdout=True)], [sg.B('Clear')]]
	return layout

def myWindow(title):
	layout=myLayout()
	window = sg.Window(title, layout,font=fnt, location=(200,100), resizable=True, finalize=True) #size=(500,200)
	return window
def mainLoop(window):
	fnt = 'Arial 18'
	window['Generate'].update(disabled=True)
	window['Build'].update(disabled=True)
	gen=False
	build=False
	genDirs=[]
	while True:                             # The Event Loop
		event, values = window.read() 
		print(event, values)
		if event == sg.WIN_CLOSED or event == 'Exit':
			break
		if event == 'Submit':
			opt=readOptions(window,values)  
			print(opt)
			if not gen:	
				window['Generate'].update(disabled=False)
				window.Refresh()
				gen=True		
		if event == 'BrowseFile':
			fname=sg.popup_get_file('Select ICD file',font=fnt, file_types=(('ALL Files', '*.*'),('old excel Files', '*.xls'),('excel Files', '*.xlsx')),no_window=True)
			window['-IN-'].update(fname)
		if event == 'BrowseDir':
			dname=sg.popup_get_folder('Select Output Base Directory', no_window=True)
			window['-OUT-'].update(dname)	
			window.Refresh()
		if event == 'Generate':
			if not opt==None: 
				print(opt)
				genDirs=generateFiles(opt)
				if not build:	
					window['Build'].update(disabled=False)
					window.Refresh()
					Build=True
			else:
				print("Parameters are not set")
		if event == 'Build':
			if not genDirs==None:
				try:
					buildCode(genDirs)
				except Exception as ex:
					print(ex)
		if event == 'Clear':
			window['-ML-']('')
				

if __name__ =="__main__":
	pwd=os.getcwd()
	gendir=os.environ["PYGEN"]
	if gendir=="":
		print ("Please set the env variable PYGEN = the Geneartor root directory")
		exit()  
	if  not checkACS():
		print ("ACS Enviroment is not set")
		exit()
	introot = os.environ["INTROOT"]
	if introot=="":
		print("INTROOT variable is not set")
		exit()
	
	os.chdir(gendir)
	window=myWindow('Device Code Generator v1.0 by GT@astri')
	mainLoop(window)
	window.close()
	os.chdir(pwd)
	"""	
	    command ="make install"
	    if execACSCommand(command):
	       print ("ERROR executing: ",command)
	       os.chdir(pwd)
	       exit()
	  os.chdir(pwd)
	  
	  command="cdbChecker"
	  if execACSCommand(command):
	    print ("ERROR executing: ",command)
	    exit()
	"""
	print ("ALL Done")
		
	
