#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
#from getSheets import myIcd
from GenDevice.excelIcd import excelIcd
import sys,os
from optparse import OptionParser
import subprocess
from GenDevice.genFromTemplates import genFromTemplates
from GenDevice.createEmptyCDB import *
from GenDevice.acsUtils import *
import pandas as pd
import glob

outdir="/tmp/"

gendir=os.environ["PYGEN"]
if gendir=="":
	print ("Please set the env variable PYGEN = the Geneartor root directory")
	exit()  
if  not checkACS():
	print ("ACS Enviroment is not set")
	exit()
def generateComponent(config,install=False):
	pwd=os.getcwd()
	wb=excelIcd(config['icdfile'])
	smain= wb.book.parse("Main")
	devs= smain['Device Name']
	#comp=smain['Component Name']
	assembly=smain['Assembly']
	#outfile=[]
	if len(devs)>1 :
		print ("the Assembly:"+assembly[0]+" includes more than one device\n",devs)
		for dev in devs:
			print("working On device:", dev)
			outf=manageICDFiles(dev,outdir,wb)
			#outfile.append(outf)
			print("Working on files:",dev)
			wb1=excelIcd(outf)
			mygen=genFromTemplates(wb1,outf,config['prefix'],config['module'],config['basedir'])
			mygen.generateFileInDir()
			if install :
				build(mygen)
				
		removetmpfiles()			   
	else:
		print ("the Assembly:"+assembly[0]+" includes one device\n",devs)
		#outf=manageICDFiles(devs[0],outdir,wb)
		mygen=genFromTemplates(wb,config['icdfile'],config['prefix'],config['module'],config['basedir'])
		mygen.generateFileInDir()
		checkCDB(mygen)
		if install :
			build(mygen)
			checkCDB(mygen)
	os.chdir(pwd)

def manageICDFiles(dev,outdir,wb):
	query="`Device Name` =="+ "'"+dev+"'"
	main=(wb.book.parse("Main")).query(query)
	get=(wb.book.parse("GET")).query(query)
	sett=(wb.book.parse("SET")).query(query)
	cmd=(wb.book.parse("CMD")).query(query)
	mode=(wb.book.parse("MODE")).query(query)
	outfile=outdir+dev+".xlsx"
	with pd.ExcelWriter(outfile) as writer:
		main.to_excel(writer,sheet_name='Main', index=False)
		get.to_excel(writer,sheet_name='GET',index=False)
		sett.to_excel(writer,sheet_name='SET',index=False)
		cmd.to_excel(writer,sheet_name='CMD',index=False)
		mode.to_excel(writer,sheet_name='MODE',index=False)
	return outfile

def build(mygen):
	  introot = os.environ["INTROOT"]
	  if introot=="":
	     print("INTROOT variable is not set")
	  else:
	     pwd=os.getcwd()
	     os.chdir(mygen._dirs['src'])
	     print ("Make Build ")
	     command="make clean all install"
	     print ("Executing:",command,'\n',"...Please wait it will take some minutes")
	     if execACSCommand(command):
	        print ("ERROR executing: ",command)
	        return
	     os.chdir(pwd)
	     checkCDB(mygen)
	  return

def checkCDB(mygen):
	pwd=os.getcwd()
	#os.chdir(mygen._dirs['test'])
	print ("Check CDB in", os.getcwd())
	command="./setCDB.sh ; cdbChecker"
	print ("Executing:",command,'\n',"...Please wait....")
	if execACSCommand(command):
		print ("ERROR executing: ",command)
		return
	
	os.chdir(pwd)
	return

def removetmpfiles():

	filelist = glob.glob(outdir+'*.xlsx')
	for fil in filelist:
		try:
	    		os.remove(fil)
		except OSError as e:
	    		print ("Error: %s - %s." % (e.filename, e.strerror))

if __name__ =="__main__":
	parser = OptionParser()
	today = date.today()
	pwd=os.getcwd()
	parser.add_option("-f", "--file", dest="bookfile",
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-d", "--dir", dest="basedir", default="./tmp",
                  help="Root dir where to install the new device ", metavar="DIR")
	parser.add_option("-p", "--prefix", dest="prefix", default="astri",
                  help="pkg prefix es. astri ", metavar="PREFIX")
	parser.add_option("-m", "--module", dest="module", default="tcs",
                  help="module name es.tcs ", metavar="MODULE")
	parser.add_option("-i", "--install", dest="install", default=False,
                  help="execute the Makefile in src dir ", metavar="INSTALL")
	(options, args) = parser.parse_args()
	print("running genDevice with the following options:\n", options)
	config={}
	config['icdfile']=options.bookfile
	config['prefix']=options.prefix
	config['module']=options.module
	config['basedir']=options.basedir
	generateComponent(config,install=options.install)
	print ("ALL Done")
	os.chdir(pwd)
		
	
