#! /usr/bin/env python

from Cheetah.Template import Template
from datetime import date
from getSheets import myIcd
import sys,os
from optparse import OptionParser
import subprocess
from genFromTemplates import genFromTemplates
from createEmptyCDB import *
from acsUtils import *


if __name__ =="__main__":
	parser = OptionParser()
	today = date.today()
	parser.add_option("-f", "--file", dest="bookfile",
                  help="ICD Exel File ", metavar="FILE")
	parser.add_option("-d", "--dir", dest="basedir", default=".",
                  help="Root dir where to install the new device ", metavar="DIR")
	parser.add_option("-i", "--install", dest="install", default="true",
                  help="execute the Makefile in src dir ", metavar="INSTALL")
	(options, args) = parser.parse_args()
	gendir=os.environ["PYGEN"]
	if gendir=="":
		print ("Please set the env variable PYGEN = the Geneartor Directory")
		exit()  
	if  not checkACS():
		print ("ACS Enviroment is not set")
		exit()
	print (options.bookfile)
	wbook=myIcd(options.bookfile)
	if wbook.book == None:
	   sys.exit(1)
	mygen=genFromTemplates(options.bookfile)
	mygen.generateFilesNoGUI()
	print (mygen.genFileNoGUI)
	dirname=wbook.MainSheet["Assembly"][0]
	basedir=options.basedir
	if not os.path.exists(basedir):
		 os.mkdir(basedir)
	outdir=os.path.join(basedir,dirname)
	print ("output directory is:",outdir)
        #cdbdir=os.path.join(os.environ["ACS_CDB"],"CDB")
	print ("generating ACS device directory")
	if createACSDir(basedir,dirname):
		print (today.strftime("%y/%m/%d"),"....All done!")
	else:
		print (today.strftime("%y/%m/%d"),"ERROR: check your input args!")
		exit()
	print ("Installing IDL and Schema files")
	targetFileBaseIdl = os.path.join(outdir,"idl")+"/"+mygen.genFileNoGUI[0]
	
	command="mv "+mygen.genFileNoGUI[0] + " "+ os.path.join(outdir,"idl")+"/.;"
	command=command + "mv "+mygen.genFileNoGUI[1] + " "+ os.path.join(outdir,"config/CDB/schemas")+"/.;"
	targetFileIdl = os.path.join(outdir,"idl")+"/"+mygen.genFile[5]
	if not os.path.exists(targetFileIdl):
		command=command + "mv "+mygen.genFileNoGUI[5] + " "+ os.path.join(outdir,"idl")+"/.;"
	else:
		print ("file: ", targetFileIdl, " Already exist")
		command = command+ "rm "+mygen.genFile[5]+";"
	command=command + "mv "+mygen.genFileNoGUI[6] + " "+ os.path.join(outdir,"src")+"/.;"
	#command=command + "mv "+mygen.genFileNoGUI[8] + " "+ os.path.join(outdir,"test")+"/.;"
	command=command + "cp -n "+gendir +"/config/tatTemplates/*" " "+ os.path.join(outdir,"test")+"/"
	print (command)
	if execACSCommand(command):
		print ("ERROR executing: ",command)
		exit()
	pwd=os.getcwd()
	# Create the CBD in /test and the setCDB.sh scipt"
	createCBDBaseDir(outdir+"/test")
	setCDBEnvVar(outdir+"/test")
	createCDBDirs()
	createManagerXml()
	createJavaContXml("frodoContainer")
	os.chdir(pwd) 
	cdbdir=os.environ["ACS_CDB"]+"/CDB"
	# install the component.xml file
	cdirMaci=os.path.join(cdbdir,"MACI/Components")
	print (cdirMaci)
	#os.chdir(cdirMaci)
	xmldir=os.path.join(cdbdir,"alma/"+dirname)
	if not os.path.exists(xmldir):
			os.mkdir(xmldir)
	else:
			print ("Directory:", xmldir," already exists")	
	command="mv -u "+mygen.genFileNoGUI[2]+ " "+ os.path.join(cdbdir,"alma/"+dirname)+"/."
	print (command)
	if execACSCommand(command):
			print ("ERROR executing: ",command)
			exit(1)
	compdir=os.path.join(cdirMaci,dirname)
	if not os.path.exists(compdir):
			os.mkdir(compdir)
	else:
			print ("Directory:", compdir," already exists")
	command="mv -u "+mygen.genFileNoGUI[3]+ " "+ compdir+"/"+mygen.genFileNoGUI[3].replace("_component","")
	print (command)
	if execACSCommand(command):
			print ("2- ERROR executing: ",command)
			exit(2)
	else:
			print ("......CDB Created")
	dirBaseImpl=os.path.join(outdir,("src/astrima/tcs/"+dirname+"BaseImpl"))
	
	if options.install == "true":
	  os.chdir(os.path.join(outdir,"src"))
	  cpwd=os.getcwd()
	  print ("Make Build ")
	  print (os.path.exists(os.path.join(cpwd,("astrima/tcs/"+dirname+"BaseImpl"))),"****")
	  if not os.path.exists(os.path.join(cpwd,("astrima/tcs/"+dirname+"BaseImpl"))):
	     print (dirBaseImpl)
	     command="make clean all"
	     print (command)
	     if execACSCommand(command):
	        print ("3- EXPECTED ERROR executing: ",command,) 
	 	   
	  dir1=cpwd+"/astrima/tcs/"+dirname+"BaseImpl/"+dirname
	  dir2=cpwd+"/astrima/tcs/"+dirname+"Impl/"+dirname
	  print ("****",dir1,dir2,"****")
	  command="mv -u "+ dir1+"BaseComponentHelper.java.tpl"+" "+dir1+"BaseComponentHelper.java;"
	  print ("****",command,"****")
	  command=command+"mv -u "+os.path.join(pwd,mygen.genFileNoGUI[4])+" "+cpwd+"/astrima/tcs/"+dirname+"BaseImpl/.;"
	  implFile = os.path.join(cpwd,"astrima/tcs/"+dirname+"Impl/"+mygen.genFileNoGUI[7])
	  if not os.path.exists(implFile):	
	    command=command+"mv -u "+ dir2+"ComponentHelper.java.tpl"+" "+dir2+"ComponentHelper.java;"
	    command=command+"mv -u "+os.path.join(pwd,mygen.genFile[7])+" "+cpwd+"/astrima/tcs/"+dirname+"Impl/.;"	
	  else: 
	    print ("File: ",implFile," Already exist")
	    command=command+"rm "+os.path.join(pwd,mygen.genFileNoGUI[7])+";"
	  print (command)
	  if execACSCommand(command):
	    print ("4-ERROR executing: ",command)
	    os.chdir(pwd)
	    exit()
	  else:
	    command ="make clean all install"
	    if execACSCommand(command):
	       print ("ERROR executing: ",command)
	       os.chdir(pwd)
	       exit()
	  os.chdir(pwd)
	  
	  command="cdbChecker"
	  if execACSCommand(command):
	    print ("ERROR executing: ",command)
	    exit()
	print ("ALL Done")
		
	
