/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import cta.acs.opcua.da.UaDataSupport;
import java.math.BigInteger;

public class UaDataSupportUNumber
extends UaDataSupport {
    public UaDataSupportUNumber(String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(serverURI, nodeIdRef);
    }

    @Override
    public Number get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof UnsignedInteger) {
            return ((UnsignedInteger)value).longValue();
        }
        if (value instanceof UnsignedLong) {
            return ((UnsignedLong)value).bigIntegerValue();
        }
        if (value instanceof UnsignedShort) {
            return ((UnsignedShort)value).intValue();
        }
        if (value instanceof UnsignedByte) {
            return ((UnsignedByte)value).shortValue();
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        UnsignedInteger out = null;
        if (value != null) {
            if (value instanceof Long) {
                out = UnsignedInteger.valueOf((long)((Long)value));
            } else if (value instanceof Integer) {
                out = UnsignedShort.valueOf((int)((Integer)value));
            } else if (value instanceof Short) {
                out = UnsignedByte.valueOf((int)((Short)value).intValue());
            } else if (value instanceof BigInteger) {
                out = UnsignedLong.valueOf((BigInteger)((BigInteger)value));
            } else {
                throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
            }
        }
        super.set(out, completionHolder);
    }
}

