/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import cta.acs.opcua.da.UaDataSupport;
import java.util.logging.Level;

public class UaDataSupportUInt16
extends UaDataSupport {
    public UaDataSupportUInt16(String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(serverURI, nodeIdRef);
    }

    @Override
    public Integer get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value instanceof UnsignedShort) {
            return ((UnsignedShort)value).intValue();
        }
        this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected result type: " + value.getClass());
        if (value instanceof UnsignedByte) {
            return ((UnsignedByte)value).intValue();
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof Integer) {
                super.set(UnsignedShort.valueOf((int)((Integer)value)), completionHolder);
                return;
            }
            this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected argument type: " + value.getClass());
            if (value instanceof Short) {
                super.set(UnsignedShort.valueOf((int)((Short)value).intValue()), completionHolder);
                return;
            } else {
                if (!(value instanceof Byte)) throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
                super.set(UnsignedShort.valueOf((int)((Byte)value).intValue()), completionHolder);
            }
            return;
        } else {
            super.set(null, completionHolder);
        }
    }
}

