/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import cta.acs.opcua.da.UaDataSupport;

public class UaDataSupportStrings
extends UaDataSupport {
    public UaDataSupportStrings(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public String[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            String[] resValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                Object obj = values[i];
                if (obj != null) {
                    resValues[i] = obj.toString();
                }
                ++i;
            }
            return resValues;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof String[]) {
                super.set(value, completionHolder);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                String[] values = new String[objects.length];
                int i = 0;
                while (i < values.length) {
                    Object obj = objects[i];
                    if (obj != null) {
                        values[i] = obj.toString();
                    }
                    ++i;
                }
            }
            throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
        }
        super.set(null, completionHolder);
    }
}

