/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import cta.acs.opcua.da.UaDataSupport;
import org.apache.commons.lang.ArrayUtils;

public class UaDataSupportIntegers
extends UaDataSupport {
    public UaDataSupportIntegers(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public int[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return new int[]{(Integer)value};
        }
        if (value instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])value));
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int[] resValues = new int[values.length];
            int i = 0;
            while (i < values.length) {
                Object obj = values[i];
                if (obj != null) {
                    if (!(obj instanceof Integer)) {
                        throw this.generateDefaultAcsException("Get failed: unexpected type " + obj.getClass(), completionHolder);
                    }
                    resValues[i] = (Integer)obj;
                }
                ++i;
            }
            return resValues;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof Integer[]) {
                super.set(value, completionHolder);
            } else if (value instanceof int[]) {
                super.set(ArrayUtils.toObject((int[])((int[])value)), completionHolder);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                Integer[] values = new Integer[objects.length];
                int i = 0;
                while (i < values.length) {
                    Object obj = objects[i];
                    if (obj != null) {
                        if (!(obj instanceof Integer)) {
                            throw this.generateDefaultAcsException("Set <" + obj + "> failed: unexpected type " + obj.getClass(), completionHolder);
                        }
                        values[i] = (Integer)obj;
                    }
                    ++i;
                }
            }
            throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
        }
        super.set(null, completionHolder);
    }
}

