/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import cta.acs.opcua.da.UaDataSupport;
import org.apache.commons.lang.ArrayUtils;

public class UaDataSupportFloats
extends UaDataSupport {
    public UaDataSupportFloats(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public float[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return new float[]{((Float)value).floatValue()};
        }
        if (value instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])value));
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            float[] resValues = new float[values.length];
            int i = 0;
            while (i < values.length) {
                Object obj = values[i];
                if (obj != null) {
                    if (!(obj instanceof Float)) {
                        throw this.generateDefaultAcsException("Get failed: unexpected type " + obj.getClass(), completionHolder);
                    }
                    resValues[i] = ((Float)obj).floatValue();
                }
                ++i;
            }
            return resValues;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof Float[]) {
                super.set(value, completionHolder);
            } else if (value instanceof float[]) {
                super.set(ArrayUtils.toObject((float[])((float[])value)), completionHolder);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                Float[] values = new Float[objects.length];
                int i = 0;
                while (i < values.length) {
                    Object obj = objects[i];
                    if (obj != null) {
                        if (!(obj instanceof Float)) {
                            throw this.generateDefaultAcsException("Set <" + obj + "> failed: unexpected type " + obj.getClass(), completionHolder);
                        }
                        values[i] = (Float)obj;
                    }
                    ++i;
                }
            }
            throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
        }
        super.set(null, completionHolder);
    }
}

