/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import cta.acs.opcua.da.extension.AbstractDataSupportEnum;
import java.util.logging.Level;
import org.omg.CORBA.portable.IDLEntity;

public class UaDataSupportEnumUInt
extends AbstractDataSupportEnum {
    public UaDataSupportEnumUInt(Class<? extends IDLEntity> clazz, String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(clazz, serverURI, nodeIdRef);
    }

    @Override
    public Object get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof UnsignedInteger) {
            return this.fromInt(((UnsignedInteger)value).intValue(), completionHolder);
        }
        this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected result type: " + value.getClass());
        if (value instanceof UnsignedLong) {
            return this.fromInt(((UnsignedLong)value).intValue(), completionHolder);
        }
        if (value instanceof UnsignedShort) {
            return this.fromInt(((UnsignedShort)value).intValue(), completionHolder);
        }
        if (value instanceof UnsignedByte) {
            return this.fromInt(((UnsignedByte)value).intValue(), completionHolder);
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object instance, CompletionHolder completionHolder) throws AcsJException {
        try {
            UnsignedInteger uI1 = UnsignedInteger.getFromBits((int)this.toInt(instance));
            super.set(uI1, completionHolder);
        }
        catch (Exception e) {
            throw this.generateDefaultAcsException("Set failed: " + e.getMessage(), completionHolder);
        }
    }

    protected Object fromInt(int value, CompletionHolder completionHolder) throws AcsJException {
        try {
            return this.fromInt(value);
        }
        catch (Exception e) {
            throw this.generateDefaultAcsException("Get failed: " + e.getMessage(), completionHolder);
        }
    }
}

