/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import cta.acs.opcua.da.UaDataSupport;
import org.apache.commons.lang.ArrayUtils;

public class UaDataSupportDoubles
extends UaDataSupport {
    public UaDataSupportDoubles(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public double[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = null;
        value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return new double[]{(Double)value};
        }
        if (value instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])value));
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            double[] resValues = new double[values.length];
            int i = 0;
            while (i < values.length) {
                Object obj = values[i];
                if (obj != null) {
                    if (!(obj instanceof Double)) {
                        throw this.generateDefaultAcsException("Get failed: unexpected type " + obj.getClass(), completionHolder);
                    }
                    resValues[i] = (Double)obj;
                }
                ++i;
            }
            return resValues;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof Double[]) {
                super.set(value, completionHolder);
            } else if (value instanceof double[]) {
                super.set(ArrayUtils.toObject((double[])((double[])value)), completionHolder);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                Double[] values = new Double[objects.length];
                int i = 0;
                while (i < values.length) {
                    Object obj = objects[i];
                    if (obj != null) {
                        if (!(obj instanceof Double)) {
                            throw this.generateDefaultAcsException("Set <" + obj + "> failed: unexpected type " + obj.getClass(), completionHolder);
                        }
                        values[i] = (Double)obj;
                    }
                    ++i;
                }
            }
            throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
        }
        super.set(null, completionHolder);
    }
}

