/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.acs.logging.AcsLogLevel;
import cta.acs.opcua.da.UaDataSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.omg.CORBA.portable.IDLEntity;

public abstract class AbstractDataSupportEnum
extends UaDataSupport {
    private final Class<? extends IDLEntity> clazz;
    private final Method methodFromInt;
    private final Method methodValue;

    public AbstractDataSupportEnum(Class<? extends IDLEntity> clazz, String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(serverURI, nodeIdRef);
        this.clazz = clazz;
        try {
            this.methodFromInt = clazz.getMethod("from_int", Integer.TYPE);
            this.methodValue = clazz.getMethod("value", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unsupported class", e);
        }
    }

    public Class<? extends IDLEntity> getClazz() {
        return this.clazz;
    }

    public Object fromInt(int value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.methodFromInt.invoke(null, value);
    }

    public int toInt(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object obj = this.methodValue.invoke(instance, new Object[0]);
        if (obj == null) {
            throw new IllegalArgumentException("Get integer representation failed: invalid invoke result");
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected argument type: " + obj.getClass());
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        throw new IllegalArgumentException("Get integer representation failed, unexpected invoke result type: " + obj.getClass());
    }
}

