/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.config;

import java.util.HashMap;

public class AlarmConfig {
    public static final String KEY_NODEID = "nodeId";
    public static final String KEY_SOURCE = "source";
    public static final String KEY_SEVERITY_THRESHOLD = "severityThreshold";
    public static final String KEY_FAULT_MEMBER = "faultMember";
    public static final String KEY_FAULT_FAMILY = "faultFamily";
    public static final String KEY_FAULT_CODE = "faultCode";
    private static final Object ENTRY_DELIMITER = ",";
    private static final Object VALUE_DELIMITER = ":";
    private final String nodeId;
    private final String source;
    private final Integer severityThreshold;
    private final String faultFamily;
    private final String faultMember;
    private final Integer faultCode;

    public AlarmConfig(Integer severityThreshold, String source, String nodeId, String faultFamily, String faultMember, Integer faultCode) throws IllegalArgumentException {
        if (severityThreshold == null) {
            throw new IllegalArgumentException("invalid argument 'severityThreshold'");
        }
        this.severityThreshold = severityThreshold;
        if (source == null || (source = source.trim()).isEmpty()) {
            throw new IllegalArgumentException("invalid argument 'source'");
        }
        this.source = source;
        if (nodeId == null || (nodeId = nodeId.trim()).isEmpty()) {
            throw new IllegalArgumentException("invalid argument 'nodeId'");
        }
        this.nodeId = nodeId;
        if (faultFamily == null || (faultFamily = faultFamily.trim()).isEmpty()) {
            throw new IllegalArgumentException("invalid argument 'faultFamily'");
        }
        this.faultFamily = faultFamily;
        if (faultMember == null || (faultMember = faultMember.trim()).isEmpty()) {
            throw new IllegalArgumentException("invalid argument 'faultMember'");
        }
        this.faultMember = faultMember;
        if (faultCode == null) {
            throw new IllegalArgumentException("invalid argument 'faultCode'");
        }
        this.faultCode = faultCode;
    }

    public static AlarmConfig valueOf(String s) throws IllegalArgumentException {
        String[] entries;
        HashMap<String, String> map = new HashMap<String, String>(5);
        String[] stringArray = entries = s.split("\\s*" + ENTRY_DELIMITER + "\\s*");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!(entry = entry.trim()).isEmpty()) {
                String[] key_value = entry.split("\\s*" + VALUE_DELIMITER + "\\s*");
                String key = null;
                if (key_value.length > 0) {
                    key = key_value[0].trim();
                    if (key.isEmpty() || map.containsKey(key)) {
                        throw new IllegalArgumentException("invalid/duplicate key: " + key);
                    }
                } else {
                    throw new IllegalArgumentException("invalid key in: " + entry);
                }
                map.put(key, key_value.length > 1 ? key_value[1].trim() : null);
            }
            ++n2;
        }
        String severityThreshold = (String)map.get(KEY_SEVERITY_THRESHOLD);
        String faultCode = (String)map.get(KEY_FAULT_CODE);
        return new AlarmConfig(severityThreshold == null ? null : Integer.valueOf(severityThreshold), (String)map.get(KEY_SOURCE), (String)map.get(KEY_NODEID), (String)map.get(KEY_FAULT_FAMILY), (String)map.get(KEY_FAULT_MEMBER), faultCode == null ? null : Integer.valueOf(faultCode));
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getSource() {
        return this.source;
    }

    public Integer getSeverityThreshold() {
        return this.severityThreshold;
    }

    public String getFaultFamily() {
        return this.faultFamily;
    }

    public String getFaultMember() {
        return this.faultMember;
    }

    public Integer getFaultCode() {
        return this.faultCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_SEVERITY_THRESHOLD).append(VALUE_DELIMITER).append(this.severityThreshold);
        sb.append(ENTRY_DELIMITER);
        sb.append(KEY_SOURCE).append(VALUE_DELIMITER).append(this.source);
        sb.append(ENTRY_DELIMITER);
        sb.append(KEY_NODEID).append(VALUE_DELIMITER).append(this.nodeId);
        sb.append(ENTRY_DELIMITER);
        sb.append(KEY_FAULT_FAMILY).append(VALUE_DELIMITER).append(this.faultFamily);
        sb.append(ENTRY_DELIMITER);
        sb.append(KEY_FAULT_MEMBER).append(VALUE_DELIMITER).append(this.faultMember);
        sb.append(ENTRY_DELIMITER);
        sb.append(KEY_FAULT_CODE).append(VALUE_DELIMITER).append(this.faultCode);
        return sb.toString();
    }
}

