/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.transport.AsyncResult;
import cta.acs.opcua.da.AbstractDataAccess;
import cta.acs.opcua.da.AbstractResultListener;
import java.io.IOException;
import java.util.List;

public class UaMethodSupport
extends AbstractDataAccess {
    public UaMethodSupport(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    private NodeId getNodeId(String nodeIdRef) throws IllegalArgumentException {
        NodeId[] nodeIds;
        if (nodeIdRef == null) {
            throw new NullPointerException("nodeIdRef == null!");
        }
        NodeId[] nodeIdArray = nodeIds = this.getNodeIds();
        int n = nodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            NodeId nodeId = nodeIdArray[n2];
            if (nodeId.toString().equals(nodeIdRef)) {
                return nodeId;
            }
            ++n2;
        }
        throw new IllegalArgumentException("bad nodeId reference: " + nodeIdRef);
    }

    public Object[] call(String nodeIdRef, String methodName, Object ... args) throws IllegalArgumentException, IOException {
        NodeId objectId = this.getNodeId(nodeIdRef);
        UaMethod method = this.getMethod(objectId, methodName);
        Variant[] inputArguments = this.parseInputArguments(method, args);
        Variant[] outputArguments = null;
        try {
            outputArguments = this.getUaClient().call(objectId, method.getNodeId(), inputArguments);
        }
        catch (MethodCallStatusException e) {
            throw new IOException("Method returns bad status: " + e.getMessage());
        }
        catch (ServiceException e) {
            throw new IOException("Method call failed: " + e.getMessage());
        }
        return this.parseOutputArguments(outputArguments);
    }

    public void callAsync(AbstractResultListener resultListener, String nodeIdRef, String methodName, Object ... args) throws IOException {
        NodeId objectId = this.getNodeId(nodeIdRef);
        UaMethod method = this.getMethod(objectId, methodName);
        Object[] inputArguments = this.parseInputArguments(method, args);
        CallMethodRequest methodsToCall = new CallMethodRequest(objectId, method.getNodeId(), inputArguments);
        resultListener.setAsyncResult((AsyncResult<CallResponse>)this.getUaClient().callAsync(new CallMethodRequest[]{methodsToCall}));
    }

    private UaMethod getMethod(NodeId nodeId, String methodName) throws IllegalArgumentException {
        List methods;
        if (methodName == null) {
            throw new IllegalArgumentException("methodName == null!");
        }
        try {
            methods = this.getUaClient().getAddressSpace().getMethods(nodeId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Browse address space failed: " + e.getMessage());
        }
        if (methods.size() == 0) {
            throw new IllegalArgumentException("No methods available in \"" + nodeId + "\"");
        }
        for (UaMethod method : methods) {
            if (!methodName.equals(method.getDisplayName().getText())) continue;
            return method;
        }
        throw new IllegalArgumentException("Method \"" + methodName + "\" is not available in \"" + nodeId + "\"");
    }

    private Variant[] parseInputArguments(UaMethod method, Object ... args) throws IllegalArgumentException, IOException {
        Argument[] inputArguments;
        try {
            inputArguments = method.getInputArguments();
        }
        catch (MethodArgumentException e) {
            throw new IllegalArgumentException("Get input arguments error: " + e.getMessage());
        }
        if (inputArguments == null || inputArguments.length == 0) {
            if (args != null && args.length != 0) {
                throw new IllegalArgumentException("Method does not accept any arguments.");
            }
            return new Variant[0];
        }
        int size = inputArguments.length;
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Method expect " + size + " arguments.");
        }
        if (size > args.length) {
            throw new IllegalArgumentException("Method expect " + size + " arguments, but passed " + args.length + ".");
        }
        AddressSpace addressSpace = this.getUaClient().getAddressSpace();
        Variant[] inputs = new Variant[size];
        int i = 0;
        while (i < size) {
            UaDataType dataType;
            try {
                dataType = (UaDataType)addressSpace.getType(inputArguments[i].getDataType());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Read [" + i + "] data type failed: " + e.getMessage());
            }
            inputs[i] = addressSpace.getDataTypeConverter().parseVariant(args[i] == null ? null : args[i].toString(), dataType);
            ++i;
        }
        return inputs;
    }

    private Object[] parseOutputArguments(Variant[] outputArguments) {
        if (outputArguments == null || outputArguments.length == 0) {
            return new Object[0];
        }
        Object[] outputs = new Object[outputArguments.length];
        int i = 0;
        while (i < outputs.length) {
            Variant variant = outputArguments[i];
            outputs[i] = variant == null ? null : variant.getValue();
            ++i;
        }
        return outputs;
    }
}

