/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public enum UaClientPool {
    INSTANCE;

    private static final String APP_NAME = "OpcUaDataAccessACS";
    private static AcsLogger m_LOGGER;
    private static final ConcurrentHashMap<String, UaClient> CLIENTS;
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTERS;

    static {
        m_LOGGER = ClientLogManager.getAcsLogManager().getLoggerForApplication(APP_NAME, true);
        CLIENTS = new ConcurrentHashMap();
        COUNTERS = new ConcurrentHashMap();
    }

    public static boolean isConnected(String serverUri) {
        UaClient client = CLIENTS.get(serverUri);
        if (client != null) {
            return client.isConnected();
        }
        throw new IllegalArgumentException("[" + serverUri + "] Client is not initialized.");
    }

    public static void create(String serverUri) throws IOException {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            m_LOGGER.log((Level)AcsLogLevel.DEBUG, "[" + serverUri + "] Creating connection ...");
            try {
                client = new UaClient(serverUri);
                ApplicationDescription appDescription = new ApplicationDescription();
                appDescription.setApplicationName(LocalizedText.english((String)APP_NAME));
                appDescription.setApplicationUri("urn:localhost:UA:OpcUaDataAccessACS");
                appDescription.setProductUri("urn:astri.it:UA:OpcUaDataAccessACS");
                appDescription.setApplicationType(ApplicationType.Client);
                ApplicationIdentity identity = new ApplicationIdentity();
                identity.setApplicationDescription(appDescription);
                client.setApplicationIdentity(identity);
                client.setLocale(Locale.ENGLISH);
                client.setTimeout(3000L);
                client.setSecurityMode(SecurityMode.NONE);
                client.setUserIdentity(new UserIdentity());
                client.setKeepSubscriptions(false);
                CLIENTS.put(serverUri, client);
            }
            catch (SessionActivationException e) {
                throw new IllegalArgumentException("session activation failure", e);
            }
        } else {
            m_LOGGER.log((Level)AcsLogLevel.TRACE, "[" + serverUri + "] Client already created.");
        }
    }

    public static void connect(String serverUri) throws IOException {
        UaClientPool.create(serverUri);
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new IOException("[" + serverUri + "] Create client failed.");
        }
        if (!client.isConnected()) {
            m_LOGGER.log((Level)AcsLogLevel.DEBUG, "[" + serverUri + "] Connecting, security mode: " + client.getSecurityMode() + " ...");
            try {
                client.connect();
                m_LOGGER.log((Level)AcsLogLevel.INFO, "[" + serverUri + "] Connected, communication state: " + client.getServerState());
            }
            catch (ServerConnectionException e) {
                throw new IOException("service connection failure", e);
            }
            catch (ServiceException e) {
                throw new IOException("service failure", e);
            }
        }
        INSTANCE.incrementCounter(serverUri);
    }

    public static void reconnect(String serverUri) throws IOException {
        if (serverUri == null) {
            throw new NullPointerException("serverUri == null");
        }
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new IOException("[" + serverUri + "] Client is not initilized.");
        }
        m_LOGGER.log((Level)AcsLogLevel.INFO, "[" + serverUri + "] Trying to reconnect, security mode: " + client.getSecurityMode() + " ...");
        try {
            client.reconnect();
            m_LOGGER.log((Level)AcsLogLevel.DEBUG, "[" + serverUri + "] Reconnected, server status: " + client.getServerStatus());
        }
        catch (StatusException e) {
            throw new IOException("[" + serverUri + "] Get server status failed.", e);
        }
        catch (ServerConnectionException e) {
            throw new IOException("[" + serverUri + "] Service connection failure.", e);
        }
        catch (ServiceException e) {
            throw new IOException("[" + serverUri + "] Service failure.", e);
        }
    }

    public static void disconnect(String serverUri) throws IllegalArgumentException {
        if (serverUri == null) {
            throw new NullPointerException("uri == null!");
        }
        if (INSTANCE.decrementCounter(serverUri) > 0) {
            return;
        }
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            m_LOGGER.log((Level)AcsLogLevel.WARNING, "[" + serverUri + "] No client to disconnect.");
            return;
        }
        if (client.isConnected()) {
            m_LOGGER.log((Level)AcsLogLevel.INFO, "[" + client.getAddress().getAddress() + "] Disconnecting client ...");
            client.disconnect();
            INSTANCE.remove(serverUri);
        }
    }

    public static void shutdown() {
        m_LOGGER.log((Level)AcsLogLevel.TRACE, "Shutting down OPC UA stack and connections ...");
        UaClientPool.disconnectAll();
        try {
            StackUtils.shutdown();
            m_LOGGER.log((Level)AcsLogLevel.DEBUG, "OPC UA stack and connections are shutted down.");
        }
        catch (Throwable e) {
            m_LOGGER.log((Level)AcsLogLevel.ERROR, "OPC UA stack shutdown failed: " + e.getMessage());
        }
    }

    public static void disconnectAll() {
        m_LOGGER.log((Level)AcsLogLevel.INFO, "Disconnecting all client(s) ...");
        ((ConcurrentHashMap.KeySetView)CLIENTS.keySet()).forEach(uri -> {
            try {
                UaClientPool.disconnect(uri);
            }
            catch (Throwable e) {
                m_LOGGER.log((Level)AcsLogLevel.WARNING, "[" + uri + "] Disconnect client failed: " + e.getMessage());
            }
        });
        CLIENTS.clear();
        COUNTERS.clear();
    }

    public static void setMaxByteStringLength(String serverUri, Integer maxByteStringLength) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setMaxByteStringLength(maxByteStringLength);
    }

    public static void setMaxArrayLength(String serverUri, Integer maxArrayLength) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setMaxArrayLength(maxArrayLength);
    }

    public static void setMaxBufferSize(String serverUri, Integer maxBufferSize) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setMaxBufferSize(maxBufferSize);
    }

    public static void setMaxMessageSize(String serverUri, Integer maxMessageSize) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setMaxMessageSize(maxMessageSize);
    }

    public static void setMaxStringLength(String serverUri, Integer maxStringLength) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setMaxStringLength(maxStringLength);
    }

    public static void setOperationTimeout(String serverUri, Integer operationTimeout) {
        UaClient client = CLIENTS.get(serverUri);
        if (client == null) {
            throw new NullPointerException("[" + serverUri + "] Client is not initilized.");
        }
        client.getEndpointConfiguration().setOperationTimeout(operationTimeout);
    }

    UaClient getClient(String serverUri) {
        return CLIENTS.get(serverUri);
    }

    void remove(String serverUri) {
        m_LOGGER.log((Level)AcsLogLevel.DEBUG, "[" + serverUri + "] Removing client from the pool ...");
        CLIENTS.remove(serverUri);
    }

    private int incrementCounter(String uri) {
        AtomicInteger newValue;
        AtomicInteger value = COUNTERS.get(uri);
        if (value == null && (value = COUNTERS.putIfAbsent(uri, newValue = new AtomicInteger())) == null) {
            value = newValue;
        }
        int res = value.incrementAndGet();
        m_LOGGER.log((Level)AcsLogLevel.TRACE, "[" + uri + "] Connection added, now " + res + " alive connections ...");
        return res;
    }

    private int decrementCounter(String uri) {
        AtomicInteger value = COUNTERS.get(uri);
        int res = value == null ? 0 : value.decrementAndGet();
        m_LOGGER.log((Level)AcsLogLevel.TRACE, "[" + uri + "] Connection removed, still " + res + " alive connections ...");
        return res;
    }
}

