/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.UadpDataSetMessageContentMask;
import com.prosysopc.ua.stack.core.UadpNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.UadpDataSetReaderMessageType;
import com.prosysopc.ua.types.opcua.server.DataSetReaderMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.UadpDataSetReaderMessageTypeNode;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21116")
public abstract class UadpDataSetReaderMessageTypeNodeBase
extends DataSetReaderMessageTypeNode
implements UadpDataSetReaderMessageType {
    private static GeneratedNodeInitializer<UadpDataSetReaderMessageTypeNode> Iu;

    protected UadpDataSetReaderMessageTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<UadpDataSetReaderMessageTypeNode> generatedNodeInitializer = UadpDataSetReaderMessageTypeNodeBase.getUadpDataSetReaderMessageTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((UadpDataSetReaderMessageTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<UadpDataSetReaderMessageTypeNode> getUadpDataSetReaderMessageTypeNodeInitializer() {
        return Iu;
    }

    public static void setUadpDataSetReaderMessageTypeNodeInitializer(GeneratedNodeInitializer<UadpDataSetReaderMessageTypeNode> generatedNodeInitializer) {
        Iu = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getNetworkMessageNumber() {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageNumber does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageNumber(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageNumber failed unexpectedly", statusException);
        }
    }

    public void setNetworkMessageNumber(int n2) {
        this.setNetworkMessageNumber(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getPublishingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getPublishingInterval() {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublishingInterval does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setPublishingInterval(Double d2) {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishingInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpDataSetMessageContentMask getDataSetMessageContentMask() {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpDataSetMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetMessageContentMask(UadpDataSetMessageContentMask uadpDataSetMessageContentMask) {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uadpDataSetMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getReceiveOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReceiveOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getReceiveOffset() {
        UaProperty uaProperty = this.getReceiveOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ReceiveOffset does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setReceiveOffset(Double d2) {
        UaProperty uaProperty = this.getReceiveOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReceiveOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReceiveOffset failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProcessingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProcessingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getProcessingOffset() {
        UaProperty uaProperty = this.getProcessingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ProcessingOffset does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setProcessingOffset(Double d2) {
        UaProperty uaProperty = this.getProcessingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProcessingOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProcessingOffset failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getGroupVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getGroupVersion() {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node GroupVersion does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setGroupVersion(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting GroupVersion failed unexpectedly", statusException);
        }
    }

    public void setGroupVersion(long l2) {
        this.setGroupVersion(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask uadpNetworkMessageContentMask) {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uadpNetworkMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetOffset() {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetOffset does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetOffset(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetOffset failed unexpectedly", statusException);
        }
    }

    public void setDataSetOffset(int n2) {
        this.setDataSetOffset(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getDataSetClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UUID getDataSetClassId() {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetClassId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UUID)object;
    }

    @Override
    @Mandatory
    public void setDataSetClassId(UUID uUID) {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uUID);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetClassId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

