/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ThreeDCartesianCoordinatesType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.CartesianCoordinatesTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDCartesianCoordinatesTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18774")
public abstract class ThreeDCartesianCoordinatesTypeNodeBase
extends CartesianCoordinatesTypeNode
implements ThreeDCartesianCoordinatesType {
    private static GeneratedNodeInitializer<ThreeDCartesianCoordinatesTypeNode> Ib;

    protected ThreeDCartesianCoordinatesTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getZNode());
        this.callAfterCreateIfExists(this.getXNode());
        this.callAfterCreateIfExists(this.getYNode());
        GeneratedNodeInitializer<ThreeDCartesianCoordinatesTypeNode> generatedNodeInitializer = ThreeDCartesianCoordinatesTypeNodeBase.getThreeDCartesianCoordinatesTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ThreeDCartesianCoordinatesTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ThreeDCartesianCoordinatesTypeNode> getThreeDCartesianCoordinatesTypeNodeInitializer() {
        return Ib;
    }

    public static void setThreeDCartesianCoordinatesTypeNodeInitializer(GeneratedNodeInitializer<ThreeDCartesianCoordinatesTypeNode> generatedNodeInitializer) {
        Ib = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getZNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Z");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getZ() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getZNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Z does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setZ(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getZNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Z failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Z failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getXNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "X");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getX() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getXNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node X does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setX(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getXNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting X failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting X failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getYNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Y");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getY() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getYNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Y does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setY(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getYNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Y failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Y failed unexpectedly", statusException);
        }
    }
}

