/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.SubscriptionDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2172")
public abstract class SubscriptionDiagnosticsTypeNodeBase
extends BaseDataVariableTypeNode
implements SubscriptionDiagnosticsType {
    private static GeneratedNodeInitializer<SubscriptionDiagnosticsTypeNode> HN;

    protected SubscriptionDiagnosticsTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDisabledMonitoredItemCountNode());
        this.callAfterCreateIfExists(this.getSubscriptionIdNode());
        this.callAfterCreateIfExists(this.getRepublishMessageRequestCountNode());
        this.callAfterCreateIfExists(this.getMaxLifetimeCountNode());
        this.callAfterCreateIfExists(this.getUnacknowledgedMessageCountNode());
        this.callAfterCreateIfExists(this.getNotificationsCountNode());
        this.callAfterCreateIfExists(this.getEnableCountNode());
        this.callAfterCreateIfExists(this.getTransferredToSameClientCountNode());
        this.callAfterCreateIfExists(this.getMonitoringQueueOverflowCountNode());
        this.callAfterCreateIfExists(this.getEventNotificationsCountNode());
        this.callAfterCreateIfExists(this.getRepublishMessageCountNode());
        this.callAfterCreateIfExists(this.getPriorityNode());
        this.callAfterCreateIfExists(this.getLatePublishRequestCountNode());
        this.callAfterCreateIfExists(this.getPublishRequestCountNode());
        this.callAfterCreateIfExists(this.getMaxNotificationsPerPublishNode());
        this.callAfterCreateIfExists(this.getDisableCountNode());
        this.callAfterCreateIfExists(this.getDiscardedMessageCountNode());
        this.callAfterCreateIfExists(this.getPublishingIntervalNode());
        this.callAfterCreateIfExists(this.getPublishingEnabledNode());
        this.callAfterCreateIfExists(this.getTransferRequestCountNode());
        this.callAfterCreateIfExists(this.getCurrentKeepAliveCountNode());
        this.callAfterCreateIfExists(this.getDataChangeNotificationsCountNode());
        this.callAfterCreateIfExists(this.getNextSequenceNumberNode());
        this.callAfterCreateIfExists(this.getRepublishRequestCountNode());
        this.callAfterCreateIfExists(this.getSessionIdNode());
        this.callAfterCreateIfExists(this.getMonitoredItemCountNode());
        this.callAfterCreateIfExists(this.getTransferredToAltClientCountNode());
        this.callAfterCreateIfExists(this.getCurrentLifetimeCountNode());
        this.callAfterCreateIfExists(this.getMaxKeepAliveCountNode());
        this.callAfterCreateIfExists(this.getEventQueueOverflowCountNode());
        this.callAfterCreateIfExists(this.getModifyCountNode());
        GeneratedNodeInitializer<SubscriptionDiagnosticsTypeNode> generatedNodeInitializer = SubscriptionDiagnosticsTypeNodeBase.getSubscriptionDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SubscriptionDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SubscriptionDiagnosticsTypeNode> getSubscriptionDiagnosticsTypeNodeInitializer() {
        return HN;
    }

    public static void setSubscriptionDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<SubscriptionDiagnosticsTypeNode> generatedNodeInitializer) {
        HN = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDisabledMonitoredItemCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DisabledMonitoredItemCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDisabledMonitoredItemCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisabledMonitoredItemCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DisabledMonitoredItemCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDisabledMonitoredItemCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisabledMonitoredItemCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DisabledMonitoredItemCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DisabledMonitoredItemCount failed unexpectedly", statusException);
        }
    }

    public void setDisabledMonitoredItemCount(long l2) {
        this.setDisabledMonitoredItemCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSubscriptionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSubscriptionId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSubscriptionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SubscriptionId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSubscriptionId(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSubscriptionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SubscriptionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubscriptionId failed unexpectedly", statusException);
        }
    }

    public void setSubscriptionId(long l2) {
        this.setSubscriptionId(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRepublishMessageRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RepublishMessageRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRepublishMessageRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishMessageRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RepublishMessageRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRepublishMessageRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishMessageRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RepublishMessageRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RepublishMessageRequestCount failed unexpectedly", statusException);
        }
    }

    public void setRepublishMessageRequestCount(long l2) {
        this.setRepublishMessageRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxLifetimeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxLifetimeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxLifetimeCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxLifetimeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxLifetimeCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxLifetimeCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxLifetimeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxLifetimeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxLifetimeCount failed unexpectedly", statusException);
        }
    }

    public void setMaxLifetimeCount(long l2) {
        this.setMaxLifetimeCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUnacknowledgedMessageCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnacknowledgedMessageCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getUnacknowledgedMessageCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnacknowledgedMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node UnacknowledgedMessageCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setUnacknowledgedMessageCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnacknowledgedMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting UnacknowledgedMessageCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnacknowledgedMessageCount failed unexpectedly", statusException);
        }
    }

    public void setUnacknowledgedMessageCount(long l2) {
        this.setUnacknowledgedMessageCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getNotificationsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NotificationsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getNotificationsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node NotificationsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setNotificationsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting NotificationsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NotificationsCount failed unexpectedly", statusException);
        }
    }

    public void setNotificationsCount(long l2) {
        this.setNotificationsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEnableCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnableCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getEnableCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEnableCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EnableCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setEnableCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEnableCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting EnableCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnableCount failed unexpectedly", statusException);
        }
    }

    public void setEnableCount(long l2) {
        this.setEnableCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransferredToSameClientCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransferredToSameClientCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransferredToSameClientCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferredToSameClientCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TransferredToSameClientCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransferredToSameClientCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferredToSameClientCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransferredToSameClientCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransferredToSameClientCount failed unexpectedly", statusException);
        }
    }

    public void setTransferredToSameClientCount(long l2) {
        this.setTransferredToSameClientCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMonitoringQueueOverflowCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MonitoringQueueOverflowCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMonitoringQueueOverflowCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMonitoringQueueOverflowCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MonitoringQueueOverflowCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMonitoringQueueOverflowCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMonitoringQueueOverflowCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MonitoringQueueOverflowCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MonitoringQueueOverflowCount failed unexpectedly", statusException);
        }
    }

    public void setMonitoringQueueOverflowCount(long l2) {
        this.setMonitoringQueueOverflowCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEventNotificationsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventNotificationsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getEventNotificationsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEventNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EventNotificationsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setEventNotificationsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEventNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting EventNotificationsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventNotificationsCount failed unexpectedly", statusException);
        }
    }

    public void setEventNotificationsCount(long l2) {
        this.setEventNotificationsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRepublishMessageCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RepublishMessageCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRepublishMessageCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RepublishMessageCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRepublishMessageCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RepublishMessageCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RepublishMessageCount failed unexpectedly", statusException);
        }
    }

    public void setRepublishMessageCount(long l2) {
        this.setRepublishMessageCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPriorityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Priority");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getPriority() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Priority does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setPriority(UnsignedByte unsignedByte) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Priority failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Priority failed unexpectedly", statusException);
        }
    }

    public void setPriority(int n2) {
        this.setPriority(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getLatePublishRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LatePublishRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getLatePublishRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLatePublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node LatePublishRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setLatePublishRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLatePublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting LatePublishRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LatePublishRequestCount failed unexpectedly", statusException);
        }
    }

    public void setLatePublishRequestCount(long l2) {
        this.setLatePublishRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getPublishRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PublishRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setPublishRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishRequestCount failed unexpectedly", statusException);
        }
    }

    public void setPublishRequestCount(long l2) {
        this.setPublishRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxNotificationsPerPublishNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxNotificationsPerPublish");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxNotificationsPerPublish() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxNotificationsPerPublishNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxNotificationsPerPublish does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxNotificationsPerPublish(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxNotificationsPerPublishNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxNotificationsPerPublish failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxNotificationsPerPublish failed unexpectedly", statusException);
        }
    }

    public void setMaxNotificationsPerPublish(long l2) {
        this.setMaxNotificationsPerPublish(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDisableCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DisableCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDisableCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisableCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DisableCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDisableCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisableCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DisableCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DisableCount failed unexpectedly", statusException);
        }
    }

    public void setDisableCount(long l2) {
        this.setDisableCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDiscardedMessageCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscardedMessageCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDiscardedMessageCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDiscardedMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DiscardedMessageCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDiscardedMessageCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDiscardedMessageCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DiscardedMessageCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiscardedMessageCount failed unexpectedly", statusException);
        }
    }

    public void setDiscardedMessageCount(long l2) {
        this.setDiscardedMessageCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingInterval");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getPublishingInterval() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PublishingInterval does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setPublishingInterval(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishingInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishingEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingEnabled");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isPublishingEnabled() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingEnabledNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PublishingEnabled does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setPublishingEnabled(Boolean bl) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingEnabledNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishingEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransferRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransferRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransferRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TransferRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransferRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransferRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransferRequestCount failed unexpectedly", statusException);
        }
    }

    public void setTransferRequestCount(long l2) {
        this.setTransferRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentKeepAliveCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentKeepAliveCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentKeepAliveCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentKeepAliveCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentKeepAliveCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentKeepAliveCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentKeepAliveCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentKeepAliveCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentKeepAliveCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentKeepAliveCount(long l2) {
        this.setCurrentKeepAliveCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDataChangeNotificationsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataChangeNotificationsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDataChangeNotificationsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDataChangeNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DataChangeNotificationsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDataChangeNotificationsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDataChangeNotificationsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DataChangeNotificationsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataChangeNotificationsCount failed unexpectedly", statusException);
        }
    }

    public void setDataChangeNotificationsCount(long l2) {
        this.setDataChangeNotificationsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getNextSequenceNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NextSequenceNumber");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getNextSequenceNumber() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNextSequenceNumberNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node NextSequenceNumber does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setNextSequenceNumber(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNextSequenceNumberNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting NextSequenceNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NextSequenceNumber failed unexpectedly", statusException);
        }
    }

    public void setNextSequenceNumber(long l2) {
        this.setNextSequenceNumber(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRepublishRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RepublishRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRepublishRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RepublishRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRepublishRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RepublishRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RepublishRequestCount failed unexpectedly", statusException);
        }
    }

    public void setRepublishRequestCount(long l2) {
        this.setRepublishRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMonitoredItemCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MonitoredItemCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMonitoredItemCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMonitoredItemCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MonitoredItemCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMonitoredItemCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMonitoredItemCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MonitoredItemCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MonitoredItemCount failed unexpectedly", statusException);
        }
    }

    public void setMonitoredItemCount(long l2) {
        this.setMonitoredItemCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransferredToAltClientCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransferredToAltClientCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransferredToAltClientCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferredToAltClientCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TransferredToAltClientCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransferredToAltClientCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferredToAltClientCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransferredToAltClientCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransferredToAltClientCount failed unexpectedly", statusException);
        }
    }

    public void setTransferredToAltClientCount(long l2) {
        this.setTransferredToAltClientCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentLifetimeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentLifetimeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentLifetimeCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentLifetimeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentLifetimeCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentLifetimeCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentLifetimeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentLifetimeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentLifetimeCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentLifetimeCount(long l2) {
        this.setCurrentLifetimeCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxKeepAliveCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxKeepAliveCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxKeepAliveCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxKeepAliveCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxKeepAliveCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxKeepAliveCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxKeepAliveCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxKeepAliveCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxKeepAliveCount failed unexpectedly", statusException);
        }
    }

    public void setMaxKeepAliveCount(long l2) {
        this.setMaxKeepAliveCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEventQueueOverflowCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventQueueOverflowCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getEventQueueOverflowCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEventQueueOverflowCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EventQueueOverflowCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setEventQueueOverflowCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEventQueueOverflowCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting EventQueueOverflowCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventQueueOverflowCount failed unexpectedly", statusException);
        }
    }

    public void setEventQueueOverflowCount(long l2) {
        this.setEventQueueOverflowCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getModifyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getModifyCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifyCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ModifyCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setModifyCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifyCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ModifyCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModifyCount failed unexpectedly", statusException);
        }
    }

    public void setModifyCount(long l2) {
        this.setModifyCount(UnsignedInteger.valueOf(l2));
    }
}

