/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.StateVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2755")
public abstract class StateVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements StateVariableType {
    private static GeneratedNodeInitializer<StateVariableTypeNode> HI;

    protected StateVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<StateVariableTypeNode> generatedNodeInitializer = StateVariableTypeNodeBase.getStateVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((StateVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<StateVariableTypeNode> getStateVariableTypeNodeInitializer() {
        return HI;
    }

    public static void setStateVariableTypeNodeInitializer(GeneratedNodeInitializer<StateVariableTypeNode> generatedNodeInitializer) {
        HI = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName getName() {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QualifiedName)object;
    }

    @Override
    @Optional
    public void setName(QualifiedName qualifiedName) {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(qualifiedName);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Name failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getId() {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setId(Object object) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEffectiveDisplayNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveDisplayName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getEffectiveDisplayName() {
        UaProperty uaProperty = this.getEffectiveDisplayNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setEffectiveDisplayName(LocalizedText localizedText) {
        UaProperty uaProperty = this.getEffectiveDisplayNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveDisplayName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EffectiveDisplayName failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Number");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getNumber() {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Number failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Number failed unexpectedly", statusException);
        }
    }

    public void setNumber(long l2) {
        this.setNumber(UnsignedInteger.valueOf(l2));
    }
}

