/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ServiceCounterDataType;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2197")
public abstract class SessionDiagnosticsVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements SessionDiagnosticsVariableType {
    private static GeneratedNodeInitializer<SessionDiagnosticsVariableTypeNode> Hq;

    protected SessionDiagnosticsVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getClientConnectionTimeNode());
        this.callAfterCreateIfExists(this.getAddReferencesCountNode());
        this.callAfterCreateIfExists(this.getSetMonitoringModeCountNode());
        this.callAfterCreateIfExists(this.getRegisterNodesCountNode());
        this.callAfterCreateIfExists(this.getTotalRequestCountNode());
        this.callAfterCreateIfExists(this.getBrowseNextCountNode());
        this.callAfterCreateIfExists(this.getWriteCountNode());
        this.callAfterCreateIfExists(this.getServerUriNode());
        this.callAfterCreateIfExists(this.getModifySubscriptionCountNode());
        this.callAfterCreateIfExists(this.getCurrentMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getUnauthorizedRequestCountNode());
        this.callAfterCreateIfExists(this.getCallCountNode());
        this.callAfterCreateIfExists(this.getTransferSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getSessionNameNode());
        this.callAfterCreateIfExists(this.getActualSessionTimeoutNode());
        this.callAfterCreateIfExists(this.getClientDescriptionNode());
        this.callAfterCreateIfExists(this.getSetTriggeringCountNode());
        this.callAfterCreateIfExists(this.getUnregisterNodesCountNode());
        this.callAfterCreateIfExists(this.getDeleteNodesCountNode());
        this.callAfterCreateIfExists(this.getCurrentSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getTranslateBrowsePathsToNodeIdsCountNode());
        this.callAfterCreateIfExists(this.getHistoryReadCountNode());
        this.callAfterCreateIfExists(this.getSetPublishingModeCountNode());
        this.callAfterCreateIfExists(this.getDeleteSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getLocaleIdsNode());
        this.callAfterCreateIfExists(this.getCreateMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getDeleteReferencesCountNode());
        this.callAfterCreateIfExists(this.getQueryFirstCountNode());
        this.callAfterCreateIfExists(this.getDeleteMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getPublishCountNode());
        this.callAfterCreateIfExists(this.getReadCountNode());
        this.callAfterCreateIfExists(this.getClientLastContactTimeNode());
        this.callAfterCreateIfExists(this.getModifyMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getAddNodesCountNode());
        this.callAfterCreateIfExists(this.getSessionIdNode());
        this.callAfterCreateIfExists(this.getCurrentPublishRequestsInQueueNode());
        this.callAfterCreateIfExists(this.getQueryNextCountNode());
        this.callAfterCreateIfExists(this.getEndpointUrlNode());
        this.callAfterCreateIfExists(this.getCreateSubscriptionCountNode());
        this.callAfterCreateIfExists(this.getRepublishCountNode());
        this.callAfterCreateIfExists(this.getBrowseCountNode());
        this.callAfterCreateIfExists(this.getMaxResponseMessageSizeNode());
        this.callAfterCreateIfExists(this.getHistoryUpdateCountNode());
        GeneratedNodeInitializer<SessionDiagnosticsVariableTypeNode> generatedNodeInitializer = SessionDiagnosticsVariableTypeNodeBase.getSessionDiagnosticsVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SessionDiagnosticsVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SessionDiagnosticsVariableTypeNode> getSessionDiagnosticsVariableTypeNodeInitializer() {
        return Hq;
    }

    public static void setSessionDiagnosticsVariableTypeNodeInitializer(GeneratedNodeInitializer<SessionDiagnosticsVariableTypeNode> generatedNodeInitializer) {
        Hq = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientConnectionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientConnectionTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getClientConnectionTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientConnectionTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientConnectionTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setClientConnectionTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientConnectionTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientConnectionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientConnectionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAddReferencesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddReferencesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getAddReferencesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AddReferencesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setAddReferencesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AddReferencesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AddReferencesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetMonitoringModeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetMonitoringModeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetMonitoringModeCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetMonitoringModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SetMonitoringModeCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetMonitoringModeCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetMonitoringModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetMonitoringModeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetMonitoringModeCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRegisterNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RegisterNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getRegisterNodesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRegisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RegisterNodesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setRegisterNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRegisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RegisterNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RegisterNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTotalRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTotalRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTotalRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TotalRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTotalRequestCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTotalRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TotalRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TotalRequestCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBrowseNextCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BrowseNextCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getBrowseNextCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node BrowseNextCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setBrowseNextCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BrowseNextCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BrowseNextCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getWriteCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "WriteCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getWriteCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getWriteCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node WriteCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setWriteCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getWriteCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting WriteCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting WriteCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getServerUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerUri() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getServerUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ServerUri does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getServerUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ServerUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getModifySubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifySubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getModifySubscriptionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifySubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ModifySubscriptionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setModifySubscriptionCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifySubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ModifySubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModifySubscriptionCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentMonitoredItemsCount(long l2) {
        this.setCurrentMonitoredItemsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUnauthorizedRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnauthorizedRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getUnauthorizedRequestCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnauthorizedRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node UnauthorizedRequestCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setUnauthorizedRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnauthorizedRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting UnauthorizedRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnauthorizedRequestCount failed unexpectedly", statusException);
        }
    }

    public void setUnauthorizedRequestCount(long l2) {
        this.setUnauthorizedRequestCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCallCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CallCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCallCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCallCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CallCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCallCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCallCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CallCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CallCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransferSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransferSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTransferSubscriptionsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TransferSubscriptionsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTransferSubscriptionsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransferSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransferSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSessionName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionName does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSessionName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getActualSessionTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActualSessionTimeout");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getActualSessionTimeout() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getActualSessionTimeoutNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ActualSessionTimeout does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setActualSessionTimeout(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getActualSessionTimeoutNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ActualSessionTimeout failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActualSessionTimeout failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientDescription");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ApplicationDescription getClientDescription() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientDescription does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ApplicationDescription)object;
    }

    @Override
    @Mandatory
    public void setClientDescription(ApplicationDescription applicationDescription) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(applicationDescription);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetTriggeringCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetTriggeringCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetTriggeringCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetTriggeringCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SetTriggeringCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetTriggeringCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetTriggeringCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetTriggeringCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetTriggeringCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUnregisterNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnregisterNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getUnregisterNodesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnregisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node UnregisterNodesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setUnregisterNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnregisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting UnregisterNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnregisterNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteNodesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DeleteNodesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentSubscriptionsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentSubscriptionsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentSubscriptionsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentSubscriptionsCount(long l2) {
        this.setCurrentSubscriptionsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTranslateBrowsePathsToNodeIdsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TranslateBrowsePathsToNodeIdsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTranslateBrowsePathsToNodeIdsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TranslateBrowsePathsToNodeIdsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTranslateBrowsePathsToNodeIdsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TranslateBrowsePathsToNodeIdsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TranslateBrowsePathsToNodeIdsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getHistoryReadCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoryReadCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getHistoryReadCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node HistoryReadCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setHistoryReadCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting HistoryReadCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HistoryReadCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetPublishingModeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetPublishingModeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetPublishingModeCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetPublishingModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SetPublishingModeCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetPublishingModeCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetPublishingModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetPublishingModeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetPublishingModeCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DeleteSubscriptionsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteSubscriptionsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getLocaleIdsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIds");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIds() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLocaleIdsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node LocaleIds does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIds(String[] stringArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLocaleIdsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting LocaleIds failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocaleIds failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCreateMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CreateMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCreateMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CreateMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CreateMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteReferencesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteReferencesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteReferencesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DeleteReferencesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteReferencesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteReferencesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteReferencesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getQueryFirstCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueryFirstCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getQueryFirstCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryFirstCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node QueryFirstCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setQueryFirstCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryFirstCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting QueryFirstCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QueryFirstCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DeleteMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getPublishCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PublishCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setPublishCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getReadCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReadCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getReadCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ReadCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setReadCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ReadCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReadCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientLastContactTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientLastContactTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getClientLastContactTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientLastContactTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientLastContactTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setClientLastContactTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientLastContactTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientLastContactTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientLastContactTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getModifyMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifyMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ModifyMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setModifyMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifyMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ModifyMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModifyMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAddNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getAddNodesCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AddNodesCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setAddNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AddNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AddNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentPublishRequestsInQueueNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentPublishRequestsInQueue");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentPublishRequestsInQueue() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentPublishRequestsInQueueNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentPublishRequestsInQueue does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentPublishRequestsInQueue(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentPublishRequestsInQueueNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentPublishRequestsInQueue failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentPublishRequestsInQueue failed unexpectedly", statusException);
        }
    }

    public void setCurrentPublishRequestsInQueue(long l2) {
        this.setCurrentPublishRequestsInQueue(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getQueryNextCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueryNextCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getQueryNextCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node QueryNextCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setQueryNextCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting QueryNextCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QueryNextCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEndpointUrl() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEndpointUrlNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EndpointUrl does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEndpointUrl(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEndpointUrlNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting EndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCreateSubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCreateSubscriptionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CreateSubscriptionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCreateSubscriptionCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CreateSubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CreateSubscriptionCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRepublishCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RepublishCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getRepublishCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RepublishCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setRepublishCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RepublishCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RepublishCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBrowseCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BrowseCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getBrowseCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node BrowseCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setBrowseCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BrowseCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BrowseCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxResponseMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxResponseMessageSize");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxResponseMessageSize() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxResponseMessageSizeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxResponseMessageSize does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxResponseMessageSizeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxResponseMessageSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxResponseMessageSize failed unexpectedly", statusException);
        }
    }

    public void setMaxResponseMessageSize(long l2) {
        this.setMaxResponseMessageSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getHistoryUpdateCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoryUpdateCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getHistoryUpdateCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryUpdateCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node HistoryUpdateCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setHistoryUpdateCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryUpdateCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting HistoryUpdateCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HistoryUpdateCount failed unexpectedly", statusException);
        }
    }
}

