/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerStatusTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2138")
public abstract class ServerStatusTypeNodeBase
extends BaseDataVariableTypeNode
implements ServerStatusType {
    private static GeneratedNodeInitializer<ServerStatusTypeNode> Hh;

    protected ServerStatusTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStateNode());
        this.callAfterCreateIfExists(this.getSecondsTillShutdownNode());
        this.callAfterCreateIfExists(this.getBuildInfoNode());
        this.callAfterCreateIfExists(this.getShutdownReasonNode());
        this.callAfterCreateIfExists(this.getStartTimeNode());
        this.callAfterCreateIfExists(this.getCurrentTimeNode());
        GeneratedNodeInitializer<ServerStatusTypeNode> generatedNodeInitializer = ServerStatusTypeNodeBase.getServerStatusTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerStatusTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerStatusTypeNode> getServerStatusTypeNodeInitializer() {
        return Hh;
    }

    public static void setServerStatusTypeNodeInitializer(GeneratedNodeInitializer<ServerStatusTypeNode> generatedNodeInitializer) {
        Hh = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getState() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node State does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (ServerState)variant.asEnum(ServerState.class);
    }

    @Override
    @Mandatory
    public void setState(ServerState serverState) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting State failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serverState);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting State failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecondsTillShutdownNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecondsTillShutdown() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecondsTillShutdownNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SecondsTillShutdown does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecondsTillShutdownNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecondsTillShutdown failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecondsTillShutdown failed unexpectedly", statusException);
        }
    }

    public void setSecondsTillShutdown(long l2) {
        this.setSecondsTillShutdown(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BuildInfoTypeNode getBuildInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildInfo");
        return (BuildInfoTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BuildInfo getBuildInfo() {
        BuildInfoTypeNode buildInfoTypeNode = this.getBuildInfoNode();
        if (buildInfoTypeNode == null) {
            throw new RuntimeException("Mandatory node BuildInfo does not exist");
        }
        Object object = buildInfoTypeNode.getValue().getValue().getValue();
        return (BuildInfo)object;
    }

    @Override
    @Mandatory
    public void setBuildInfo(BuildInfo buildInfo) {
        BuildInfoTypeNode buildInfoTypeNode = this.getBuildInfoNode();
        if (buildInfoTypeNode == null) {
            throw new RuntimeException("Setting BuildInfo failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            buildInfoTypeNode.setValue(buildInfo);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildInfo failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getShutdownReasonNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShutdownReason");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getShutdownReason() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getShutdownReasonNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ShutdownReason does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setShutdownReason(LocalizedText localizedText) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getShutdownReasonNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ShutdownReason failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ShutdownReason failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStartTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node StartTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStartTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting StartTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCurrentTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCurrentTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentTime failed unexpectedly", statusException);
        }
    }
}

