/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsSummaryType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsSummaryTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2150")
public abstract class ServerDiagnosticsSummaryTypeNodeBase
extends BaseDataVariableTypeNode
implements ServerDiagnosticsSummaryType {
    private static GeneratedNodeInitializer<ServerDiagnosticsSummaryTypeNode> He;

    protected ServerDiagnosticsSummaryTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getRejectedSessionCountNode());
        this.callAfterCreateIfExists(this.getSessionAbortCountNode());
        this.callAfterCreateIfExists(this.getServerViewCountNode());
        this.callAfterCreateIfExists(this.getCumulatedSessionCountNode());
        this.callAfterCreateIfExists(this.getSecurityRejectedRequestsCountNode());
        this.callAfterCreateIfExists(this.getSecurityRejectedSessionCountNode());
        this.callAfterCreateIfExists(this.getCurrentSubscriptionCountNode());
        this.callAfterCreateIfExists(this.getSessionTimeoutCountNode());
        this.callAfterCreateIfExists(this.getPublishingIntervalCountNode());
        this.callAfterCreateIfExists(this.getRejectedRequestsCountNode());
        this.callAfterCreateIfExists(this.getCumulatedSubscriptionCountNode());
        this.callAfterCreateIfExists(this.getCurrentSessionCountNode());
        GeneratedNodeInitializer<ServerDiagnosticsSummaryTypeNode> generatedNodeInitializer = ServerDiagnosticsSummaryTypeNodeBase.getServerDiagnosticsSummaryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerDiagnosticsSummaryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerDiagnosticsSummaryTypeNode> getServerDiagnosticsSummaryTypeNodeInitializer() {
        return He;
    }

    public static void setServerDiagnosticsSummaryTypeNodeInitializer(GeneratedNodeInitializer<ServerDiagnosticsSummaryTypeNode> generatedNodeInitializer) {
        He = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRejectedSessionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RejectedSessionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRejectedSessionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRejectedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RejectedSessionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRejectedSessionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRejectedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RejectedSessionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RejectedSessionCount failed unexpectedly", statusException);
        }
    }

    public void setRejectedSessionCount(long l2) {
        this.setRejectedSessionCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionAbortCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionAbortCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSessionAbortCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionAbortCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionAbortCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSessionAbortCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionAbortCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionAbortCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionAbortCount failed unexpectedly", statusException);
        }
    }

    public void setSessionAbortCount(long l2) {
        this.setSessionAbortCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getServerViewCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerViewCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getServerViewCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getServerViewCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ServerViewCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setServerViewCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getServerViewCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ServerViewCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerViewCount failed unexpectedly", statusException);
        }
    }

    public void setServerViewCount(long l2) {
        this.setServerViewCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCumulatedSessionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CumulatedSessionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCumulatedSessionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCumulatedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CumulatedSessionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCumulatedSessionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCumulatedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CumulatedSessionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CumulatedSessionCount failed unexpectedly", statusException);
        }
    }

    public void setCumulatedSessionCount(long l2) {
        this.setCumulatedSessionCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityRejectedRequestsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityRejectedRequestsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecurityRejectedRequestsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityRejectedRequestsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SecurityRejectedRequestsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecurityRejectedRequestsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityRejectedRequestsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityRejectedRequestsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityRejectedRequestsCount failed unexpectedly", statusException);
        }
    }

    public void setSecurityRejectedRequestsCount(long l2) {
        this.setSecurityRejectedRequestsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityRejectedSessionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityRejectedSessionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecurityRejectedSessionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityRejectedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SecurityRejectedSessionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecurityRejectedSessionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityRejectedSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityRejectedSessionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityRejectedSessionCount failed unexpectedly", statusException);
        }
    }

    public void setSecurityRejectedSessionCount(long l2) {
        this.setSecurityRejectedSessionCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentSubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentSubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentSubscriptionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentSubscriptionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentSubscriptionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentSubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentSubscriptionCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentSubscriptionCount(long l2) {
        this.setCurrentSubscriptionCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionTimeoutCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionTimeoutCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSessionTimeoutCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionTimeoutCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionTimeoutCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSessionTimeoutCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionTimeoutCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionTimeoutCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionTimeoutCount failed unexpectedly", statusException);
        }
    }

    public void setSessionTimeoutCount(long l2) {
        this.setSessionTimeoutCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishingIntervalCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingIntervalCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getPublishingIntervalCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingIntervalCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PublishingIntervalCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setPublishingIntervalCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishingIntervalCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishingIntervalCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingIntervalCount failed unexpectedly", statusException);
        }
    }

    public void setPublishingIntervalCount(long l2) {
        this.setPublishingIntervalCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRejectedRequestsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RejectedRequestsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRejectedRequestsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRejectedRequestsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RejectedRequestsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRejectedRequestsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRejectedRequestsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RejectedRequestsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RejectedRequestsCount failed unexpectedly", statusException);
        }
    }

    public void setRejectedRequestsCount(long l2) {
        this.setRejectedRequestsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCumulatedSubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CumulatedSubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCumulatedSubscriptionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCumulatedSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CumulatedSubscriptionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCumulatedSubscriptionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCumulatedSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CumulatedSubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CumulatedSubscriptionCount failed unexpectedly", statusException);
        }
    }

    public void setCumulatedSubscriptionCount(long l2) {
        this.setCumulatedSubscriptionCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentSessionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentSessionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentSessionCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentSessionCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentSessionCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSessionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentSessionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentSessionCount failed unexpectedly", statusException);
        }
    }

    public void setCurrentSessionCount(long l2) {
        this.setCurrentSessionCount(UnsignedInteger.valueOf(l2));
    }
}

