/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ServerConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateGroupFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeApplyChangesMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeCreateSigningRequestMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeGetRejectedListMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeUpdateCertificateMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12581")
public abstract class ServerConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements ServerConfigurationType {
    private static GeneratedNodeInitializer<ServerConfigurationTypeNode> GZ;
    private static ServerConfigurationTypeApplyChangesMethod Ha;
    private static ServerConfigurationTypeUpdateCertificateMethod Hb;
    private static ServerConfigurationTypeGetRejectedListMethod Hc;
    private static ServerConfigurationTypeCreateSigningRequestMethod Hd;

    protected ServerConfigurationTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCertificateGroupsNode());
        GeneratedNodeInitializer<ServerConfigurationTypeNode> generatedNodeInitializer = ServerConfigurationTypeNodeBase.getServerConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerConfigurationTypeNode> getServerConfigurationTypeNodeInitializer() {
        return GZ;
    }

    public static void setServerConfigurationTypeNodeInitializer(GeneratedNodeInitializer<ServerConfigurationTypeNode> generatedNodeInitializer) {
        GZ = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getMaxTrustListSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTrustListSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxTrustListSize() {
        UaProperty uaProperty = this.getMaxTrustListSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxTrustListSize does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxTrustListSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxTrustListSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTrustListSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTrustListSize failed unexpectedly", statusException);
        }
    }

    public void setMaxTrustListSize(long l2) {
        this.setMaxTrustListSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerCapabilities() {
        UaProperty uaProperty = this.getServerCapabilitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerCapabilities does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerCapabilities(String[] stringArray) {
        UaProperty uaProperty = this.getServerCapabilitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerCapabilities failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerCapabilities failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMulticastDnsEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MulticastDnsEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isMulticastDnsEnabled() {
        UaProperty uaProperty = this.getMulticastDnsEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MulticastDnsEnabled does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setMulticastDnsEnabled(Boolean bl) {
        UaProperty uaProperty = this.getMulticastDnsEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSupportedPrivateKeyFormatsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getSupportedPrivateKeyFormats() {
        UaProperty uaProperty = this.getSupportedPrivateKeyFormatsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SupportedPrivateKeyFormats does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setSupportedPrivateKeyFormats(String[] stringArray) {
        UaProperty uaProperty = this.getSupportedPrivateKeyFormatsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public CertificateGroupFolderTypeNode getCertificateGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateGroups");
        return (CertificateGroupFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ApplyChanges"), nodeId)) {
            this.p(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCertificate"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (NodeId)variantArray[0].getValue(), (NodeId)variantArray[1].getValue(), (ByteString)variantArray[2].getValue(), (ByteString[])variantArray[3].getValue(), (String)variantArray[4].getValue(), (ByteString)variantArray[5].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetRejectedList"), nodeId)) {
            return new Variant[]{new Variant(this.q(serviceContext))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSigningRequest"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (NodeId)variantArray[0].getValue(), (NodeId)variantArray[1].getValue(), (String)variantArray[2].getValue(), (Boolean)variantArray[3].getValue(), (ByteString)variantArray[4].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getApplyChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplyChanges");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onApplyChanges(ServiceContext var1) throws StatusException;

    @Override
    public void applyChanges() throws StatusException {
        this.p(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void p(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeApplyChangesMethod serverConfigurationTypeApplyChangesMethod = ServerConfigurationTypeNodeBase.getApplyChangesMethodImplementation();
        if (serverConfigurationTypeApplyChangesMethod != null) {
            serverConfigurationTypeApplyChangesMethod.applyChanges(serviceContext, (ServerConfigurationTypeNode)this);
        } else {
            this.onApplyChanges(serviceContext);
        }
    }

    public static ServerConfigurationTypeApplyChangesMethod getApplyChangesMethodImplementation() {
        return Ha;
    }

    public static void setApplyChangesMethodImplementation(ServerConfigurationTypeApplyChangesMethod serverConfigurationTypeApplyChangesMethod) {
        Ha = serverConfigurationTypeApplyChangesMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUpdateCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract Boolean onUpdateCertificate(ServiceContext var1, NodeId var2, NodeId var3, ByteString var4, ByteString[] var5, String var6, ByteString var7) throws StatusException;

    @Override
    public Boolean updateCertificate(NodeId nodeId, NodeId nodeId2, ByteString byteString, ByteString[] byteStringArray, String string, ByteString byteString2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
    }

    private Boolean a(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, ByteString byteString, ByteString[] byteStringArray, String string, ByteString byteString2) throws StatusException {
        ServerConfigurationTypeUpdateCertificateMethod serverConfigurationTypeUpdateCertificateMethod = ServerConfigurationTypeNodeBase.getUpdateCertificateMethodImplementation();
        if (serverConfigurationTypeUpdateCertificateMethod != null) {
            return serverConfigurationTypeUpdateCertificateMethod.updateCertificate(serviceContext, (ServerConfigurationTypeNode)this, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
        }
        return this.onUpdateCertificate(serviceContext, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
    }

    public static ServerConfigurationTypeUpdateCertificateMethod getUpdateCertificateMethodImplementation() {
        return Hb;
    }

    public static void setUpdateCertificateMethodImplementation(ServerConfigurationTypeUpdateCertificateMethod serverConfigurationTypeUpdateCertificateMethod) {
        Hb = serverConfigurationTypeUpdateCertificateMethod;
    }

    @Override
    @Mandatory
    public UaMethod getGetRejectedListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetRejectedList");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ByteString[] onGetRejectedList(ServiceContext var1) throws StatusException;

    @Override
    public ByteString[] getRejectedList() throws StatusException {
        return this.q(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private ByteString[] q(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeGetRejectedListMethod serverConfigurationTypeGetRejectedListMethod = ServerConfigurationTypeNodeBase.getGetRejectedListMethodImplementation();
        if (serverConfigurationTypeGetRejectedListMethod != null) {
            return serverConfigurationTypeGetRejectedListMethod.getRejectedList(serviceContext, (ServerConfigurationTypeNode)this);
        }
        return this.onGetRejectedList(serviceContext);
    }

    public static ServerConfigurationTypeGetRejectedListMethod getGetRejectedListMethodImplementation() {
        return Hc;
    }

    public static void setGetRejectedListMethodImplementation(ServerConfigurationTypeGetRejectedListMethod serverConfigurationTypeGetRejectedListMethod) {
        Hc = serverConfigurationTypeGetRejectedListMethod;
    }

    @Override
    @Mandatory
    public UaMethod getCreateSigningRequestNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSigningRequest");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ByteString onCreateSigningRequest(ServiceContext var1, NodeId var2, NodeId var3, String var4, Boolean var5, ByteString var6) throws StatusException;

    @Override
    public ByteString createSigningRequest(NodeId nodeId, NodeId nodeId2, String string, Boolean bl, ByteString byteString) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, nodeId2, string, bl, byteString);
    }

    private ByteString a(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, String string, Boolean bl, ByteString byteString) throws StatusException {
        ServerConfigurationTypeCreateSigningRequestMethod serverConfigurationTypeCreateSigningRequestMethod = ServerConfigurationTypeNodeBase.getCreateSigningRequestMethodImplementation();
        if (serverConfigurationTypeCreateSigningRequestMethod != null) {
            return serverConfigurationTypeCreateSigningRequestMethod.createSigningRequest(serviceContext, (ServerConfigurationTypeNode)this, nodeId, nodeId2, string, bl, byteString);
        }
        return this.onCreateSigningRequest(serviceContext, nodeId, nodeId2, string, bl, byteString);
    }

    public static ServerConfigurationTypeCreateSigningRequestMethod getCreateSigningRequestMethodImplementation() {
        return Hd;
    }

    public static void setCreateSigningRequestMethodImplementation(ServerConfigurationTypeCreateSigningRequestMethod serverConfigurationTypeCreateSigningRequestMethod) {
        Hd = serverConfigurationTypeCreateSigningRequestMethod;
    }
}

