/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.PublishedVariableDataType;
import com.prosysopc.ua.types.opcua.PublishedDataItemsType;
import com.prosysopc.ua.types.opcua.server.PublishedDataItemsTypeAddVariablesMethod;
import com.prosysopc.ua.types.opcua.server.PublishedDataItemsTypeNode;
import com.prosysopc.ua.types.opcua.server.PublishedDataItemsTypeRemoveVariablesMethod;
import com.prosysopc.ua.types.opcua.server.PublishedDataSetTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14534")
public abstract class PublishedDataItemsTypeNodeBase
extends PublishedDataSetTypeNode
implements PublishedDataItemsType {
    private static GeneratedNodeInitializer<PublishedDataItemsTypeNode> Gn;
    private static PublishedDataItemsTypeAddVariablesMethod Go;
    private static PublishedDataItemsTypeRemoveVariablesMethod Gp;

    protected PublishedDataItemsTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PublishedDataItemsTypeNode> generatedNodeInitializer = PublishedDataItemsTypeNodeBase.getPublishedDataItemsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PublishedDataItemsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PublishedDataItemsTypeNode> getPublishedDataItemsTypeNodeInitializer() {
        return Gn;
    }

    public static void setPublishedDataItemsTypeNodeInitializer(GeneratedNodeInitializer<PublishedDataItemsTypeNode> generatedNodeInitializer) {
        Gn = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getPublishedDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishedData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PublishedVariableDataType[] getPublishedData() {
        UaProperty uaProperty = this.getPublishedDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublishedData does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (PublishedVariableDataType[])object;
    }

    @Override
    @Mandatory
    public void setPublishedData(PublishedVariableDataType[] publishedVariableDataTypeArray) {
        UaProperty uaProperty = this.getPublishedDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishedData failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(publishedVariableDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishedData failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddVariables"), nodeId)) {
            return this.a(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (String[])variantArray[1].getValue(), (Boolean[])variantArray[2].getValue(), (PublishedVariableDataType[])variantArray[3].getValue()).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveVariables"), nodeId)) {
            return this.a(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (UnsignedInteger[])variantArray[1].getValue()).asVariantArray();
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getAddVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract PublishedDataItemsType.AddVariablesMethodOutputs onAddVariables(ServiceContext var1, ConfigurationVersionDataType var2, String[] var3, Boolean[] var4, PublishedVariableDataType[] var5) throws StatusException;

    @Override
    public PublishedDataItemsType.AddVariablesMethodOutputs addVariables(ConfigurationVersionDataType configurationVersionDataType, String[] stringArray, Boolean[] booleanArray, PublishedVariableDataType[] publishedVariableDataTypeArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, stringArray, booleanArray, publishedVariableDataTypeArray);
    }

    private PublishedDataItemsType.AddVariablesMethodOutputs a(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, String[] stringArray, Boolean[] booleanArray, PublishedVariableDataType[] publishedVariableDataTypeArray) throws StatusException {
        PublishedDataItemsTypeAddVariablesMethod publishedDataItemsTypeAddVariablesMethod = PublishedDataItemsTypeNodeBase.getAddVariablesMethodImplementation();
        if (publishedDataItemsTypeAddVariablesMethod != null) {
            return publishedDataItemsTypeAddVariablesMethod.addVariables(serviceContext, (PublishedDataItemsTypeNode)this, configurationVersionDataType, stringArray, booleanArray, publishedVariableDataTypeArray);
        }
        return this.onAddVariables(serviceContext, configurationVersionDataType, stringArray, booleanArray, publishedVariableDataTypeArray);
    }

    public static PublishedDataItemsTypeAddVariablesMethod getAddVariablesMethodImplementation() {
        return Go;
    }

    public static void setAddVariablesMethodImplementation(PublishedDataItemsTypeAddVariablesMethod publishedDataItemsTypeAddVariablesMethod) {
        Go = publishedDataItemsTypeAddVariablesMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract PublishedDataItemsType.RemoveVariablesMethodOutputs onRemoveVariables(ServiceContext var1, ConfigurationVersionDataType var2, UnsignedInteger[] var3) throws StatusException;

    @Override
    public PublishedDataItemsType.RemoveVariablesMethodOutputs removeVariables(ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, unsignedIntegerArray);
    }

    private PublishedDataItemsType.RemoveVariablesMethodOutputs a(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) throws StatusException {
        PublishedDataItemsTypeRemoveVariablesMethod publishedDataItemsTypeRemoveVariablesMethod = PublishedDataItemsTypeNodeBase.getRemoveVariablesMethodImplementation();
        if (publishedDataItemsTypeRemoveVariablesMethod != null) {
            return publishedDataItemsTypeRemoveVariablesMethod.removeVariables(serviceContext, (PublishedDataItemsTypeNode)this, configurationVersionDataType, unsignedIntegerArray);
        }
        return this.onRemoveVariables(serviceContext, configurationVersionDataType, unsignedIntegerArray);
    }

    public static PublishedDataItemsTypeRemoveVariablesMethod getRemoveVariablesMethodImplementation() {
        return Gp;
    }

    public static void setRemoveVariablesMethodImplementation(PublishedDataItemsTypeRemoveVariablesMethod publishedDataItemsTypeRemoveVariablesMethod) {
        Gp = publishedDataItemsTypeRemoveVariablesMethod;
    }
}

