/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.PubSubCommunicationFailureEventType;
import com.prosysopc.ua.types.opcua.server.PubSubCommunicationFailureEventTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15563")
public abstract class PubSubCommunicationFailureEventTypeNodeBase
extends PubSubStatusEventTypeNode
implements PubSubCommunicationFailureEventType {
    private static GeneratedNodeInitializer<PubSubCommunicationFailureEventTypeNode> FM;

    protected PubSubCommunicationFailureEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PubSubCommunicationFailureEventTypeNode> generatedNodeInitializer = PubSubCommunicationFailureEventTypeNodeBase.getPubSubCommunicationFailureEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubCommunicationFailureEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubCommunicationFailureEventTypeNode> getPubSubCommunicationFailureEventTypeNodeInitializer() {
        return FM;
    }

    public static void setPubSubCommunicationFailureEventTypeNodeInitializer(GeneratedNodeInitializer<PubSubCommunicationFailureEventTypeNode> generatedNodeInitializer) {
        FM = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Error");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getError() {
        UaProperty uaProperty = this.getErrorNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Error does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setError(StatusCode statusCode) {
        UaProperty uaProperty = this.getErrorNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Error failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(statusCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Error failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

