/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.types.opcua.OrientationType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.OrientationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18779")
public abstract class OrientationTypeNodeBase
extends BaseDataVariableTypeNode
implements OrientationType {
    private static GeneratedNodeInitializer<OrientationTypeNode> Fz;

    protected OrientationTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<OrientationTypeNode> generatedNodeInitializer = OrientationTypeNodeBase.getOrientationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((OrientationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<OrientationTypeNode> getOrientationTypeNodeInitializer() {
        return Fz;
    }

    public static void setOrientationTypeNodeInitializer(GeneratedNodeInitializer<OrientationTypeNode> generatedNodeInitializer) {
        Fz = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getAngleUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AngleUnit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getAngleUnit() {
        UaProperty uaProperty = this.getAngleUnitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setAngleUnit(EUInformation eUInformation) {
        UaProperty uaProperty = this.getAngleUnitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AngleUnit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AngleUnit failed unexpectedly", statusException);
        }
    }
}

