/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.NonExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.NonExclusiveLimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9906")
public abstract class NonExclusiveLimitAlarmTypeNodeBase
extends LimitAlarmTypeNode
implements NonExclusiveLimitAlarmType {
    private static GeneratedNodeInitializer<NonExclusiveLimitAlarmTypeNode> Fr;

    protected NonExclusiveLimitAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getHighStateNode());
        this.callAfterCreateIfExists(this.getActiveStateNode());
        this.callAfterCreateIfExists(this.getHighHighStateNode());
        this.callAfterCreateIfExists(this.getLowLowStateNode());
        this.callAfterCreateIfExists(this.getLowStateNode());
        GeneratedNodeInitializer<NonExclusiveLimitAlarmTypeNode> generatedNodeInitializer = NonExclusiveLimitAlarmTypeNodeBase.getNonExclusiveLimitAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NonExclusiveLimitAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NonExclusiveLimitAlarmTypeNode> getNonExclusiveLimitAlarmTypeNodeInitializer() {
        return Fr;
    }

    public static void setNonExclusiveLimitAlarmTypeNodeInitializer(GeneratedNodeInitializer<NonExclusiveLimitAlarmTypeNode> generatedNodeInitializer) {
        Fr = generatedNodeInitializer;
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting HighState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getHighHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighHighState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighHighState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighHighStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighHighState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighHighStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting HighHighState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighHighState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getLowLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLowState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowLowState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowLowStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowLowState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowLowStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting LowLowState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLowState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting LowState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

