/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.JsonNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.JsonWriterGroupMessageType;
import com.prosysopc.ua.types.opcua.server.JsonWriterGroupMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupMessageTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21126")
public abstract class JsonWriterGroupMessageTypeNodeBase
extends WriterGroupMessageTypeNode
implements JsonWriterGroupMessageType {
    private static GeneratedNodeInitializer<JsonWriterGroupMessageTypeNode> EU;

    protected JsonWriterGroupMessageTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<JsonWriterGroupMessageTypeNode> generatedNodeInitializer = JsonWriterGroupMessageTypeNodeBase.getJsonWriterGroupMessageTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((JsonWriterGroupMessageTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<JsonWriterGroupMessageTypeNode> getJsonWriterGroupMessageTypeNodeInitializer() {
        return EU;
    }

    public static void setJsonWriterGroupMessageTypeNodeInitializer(GeneratedNodeInitializer<JsonWriterGroupMessageTypeNode> generatedNodeInitializer) {
        EU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public JsonNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (JsonNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(JsonNetworkMessageContentMask jsonNetworkMessageContentMask) {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(jsonNetworkMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

