/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.ImageItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.ImageItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12047")
public abstract class ImageItemTypeNodeBase
extends ArrayItemTypeNode
implements ImageItemType {
    private static GeneratedNodeInitializer<ImageItemTypeNode> EO;

    protected ImageItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ImageItemTypeNode> generatedNodeInitializer = ImageItemTypeNodeBase.getImageItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ImageItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ImageItemTypeNode> getImageItemTypeNodeInitializer() {
        return EO;
    }

    public static void setImageItemTypeNodeInitializer(GeneratedNodeInitializer<ImageItemTypeNode> generatedNodeInitializer) {
        EO = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node XAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting XAxisDefinition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getYAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "YAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getYAxisDefinition() {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node YAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setYAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting YAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting YAxisDefinition failed unexpectedly", statusException);
        }
    }
}

