/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.types.opcua.ExpressionGuardVariableType;
import com.prosysopc.ua.types.opcua.server.ExpressionGuardVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.GuardVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15128")
public abstract class ExpressionGuardVariableTypeNodeBase
extends GuardVariableTypeNode
implements ExpressionGuardVariableType {
    private static GeneratedNodeInitializer<ExpressionGuardVariableTypeNode> Ef;

    protected ExpressionGuardVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ExpressionGuardVariableTypeNode> generatedNodeInitializer = ExpressionGuardVariableTypeNodeBase.getExpressionGuardVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ExpressionGuardVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ExpressionGuardVariableTypeNode> getExpressionGuardVariableTypeNodeInitializer() {
        return Ef;
    }

    public static void setExpressionGuardVariableTypeNodeInitializer(GeneratedNodeInitializer<ExpressionGuardVariableTypeNode> generatedNodeInitializer) {
        Ef = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getExpressionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Expression");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ContentFilter getExpression() {
        UaProperty uaProperty = this.getExpressionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Expression does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ContentFilter)object;
    }

    @Override
    @Mandatory
    public void setExpression(ContentFilter contentFilter) {
        UaProperty uaProperty = this.getExpressionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Expression failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(contentFilter);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Expression failed unexpectedly", statusException);
        }
    }
}

