/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.DialogConditionTypeNodeBase;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2830")
public class DialogConditionTypeNode
extends DialogConditionTypeNodeBase {
    protected DialogConditionTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.getDialogStateNode().setTrueState(new LocalizedText("Active"));
        this.getDialogStateNode().setFalseState(new LocalizedText("Inactive"));
    }

    @Override
    protected void onRespond(ServiceContext serviceContext, Integer n2) throws StatusException {
        if (!this.getDialogStateNode().isId().booleanValue()) {
            throw new StatusException(StatusCodes.Bad_DialogNotActive);
        }
        if (n2 >= this.getResponseOptionSet().length) {
            throw new StatusException(StatusCodes.Bad_DialogResponseInvalid);
        }
        this.getDialogStateNode().setId(false);
        this.setLastResponse(n2);
        this.triggerEvent(DateTime.currentTime(), null, null);
    }
}

