/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.BrokerConnectionTransportType;
import com.prosysopc.ua.types.opcua.server.BrokerConnectionTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.ConnectionTransportTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15155")
public abstract class BrokerConnectionTransportTypeNodeBase
extends ConnectionTransportTypeNode
implements BrokerConnectionTransportType {
    private static GeneratedNodeInitializer<BrokerConnectionTransportTypeNode> CV;

    protected BrokerConnectionTransportTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<BrokerConnectionTransportTypeNode> generatedNodeInitializer = BrokerConnectionTransportTypeNodeBase.getBrokerConnectionTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BrokerConnectionTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BrokerConnectionTransportTypeNode> getBrokerConnectionTransportTypeNodeInitializer() {
        return CV;
    }

    public static void setBrokerConnectionTransportTypeNodeInitializer(GeneratedNodeInitializer<BrokerConnectionTransportTypeNode> generatedNodeInitializer) {
        CV = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResourceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResourceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAuthenticationProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationProfileUri() {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AuthenticationProfileUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationProfileUri(String string) {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

