/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.StructureDataValue;
import com.prosysopc.ua.server.nodes.AbstractGeneratedVariableNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.BaseVariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=62")
public class BaseVariableTypeNode
extends AbstractGeneratedVariableNode
implements BaseVariableType {
    private static final Logger logger = LoggerFactory.getLogger(BaseVariableTypeNode.class);

    public BaseVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        this.semanticsChanged();
        this.egl();
    }

    private void egl() {
        if (this.getValueRank() != -1) {
            return;
        }
        if (this.getDataType() != null && this.getDataType().inheritsFrom(Identifiers.Structure)) {
            UaNodeId uaNodeId = UaNodeId.fromLocal(this.getDataTypeId(), this.getNodeManager().getNamespaceTable());
            StructureSpecification structureSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                logger.warn("Cannot get StructureSpecification for DataTypeId: {}, skipping sub-node generation", (Object)structureSpecification);
                return;
            }
            UaType uaType = this.getTypeDefinition();
            if (uaType == null) {
                return;
            }
            int n2 = uaType.getNodeId().getNamespaceIndex();
            logger.trace("ComplexTypeCheck: determining namespaceIndex of sub-components to {}", (Object)n2);
            DataValue dataValue = this.getValue();
            for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                QualifiedName qualifiedName = new QualifiedName(n2, fieldSpecification.getName());
                UaNode uaNode = this.getComponent(qualifiedName);
                if (uaNode != null) {
                    logger.trace("ComplexTypeCheck: Node has already the component named {}", (Object)qualifiedName);
                } else {
                    BaseVariableTypeNode baseVariableTypeNode = new BaseVariableTypeNode(this.getNodeManager(), this.getNodeManager().createNodeId((UaNode)this, qualifiedName), qualifiedName, new LocalizedText(fieldSpecification.getName()));
                    baseVariableTypeNode.setValueRank(-1);
                    try {
                        baseVariableTypeNode.setDataTypeId(fieldSpecification.getDataTypeId().asNodeId(this.getNodeManager().getNamespaceTable()));
                    }
                    catch (Exception exception) {
                        logger.error("Could not set the DataType NodeId for node:{}", (Object)baseVariableTypeNode, (Object)exception);
                    }
                    try {
                        Structure structure;
                        DataValue dataValue2 = dataValue.clone();
                        Structure structure2 = structure = dataValue2.isNull() ? null : (Structure)dataValue2.getValue().getValue();
                        if (structure != null) {
                            Object object = structure.get(fieldSpecification);
                            dataValue2.setValue(new Variant(object));
                            baseVariableTypeNode.setValue(dataValue2);
                        }
                    }
                    catch (Exception exception) {
                        logger.debug("Could not set part value from the Structure for field {} for nodeid {}", new Object[]{fieldSpecification, baseVariableTypeNode.getNodeId(), exception});
                    }
                    this.addComponent(baseVariableTypeNode);
                    logger.trace("Created new component for {}, component={} ", (Object)this, (Object)baseVariableTypeNode);
                    baseVariableTypeNode.afterCreate();
                    uaNode = baseVariableTypeNode;
                }
                if (uaNode instanceof UaVariable) continue;
                logger.error("ERROR, the component is not UaVariable");
            }
        }
    }

    private void a(final StructureSpecification structureSpecification, final FieldSpecification fieldSpecification, UaVariable uaVariable) {
        uaVariable.addDataChangeListener(new DataChangeListener(){

            @Override
            public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                Object object;
                if (dataValue2 instanceof StructureDataValue && ((StructureDataValue)dataValue2).isGoingToLeaf()) {
                    return;
                }
                DataValue dataValue3 = BaseVariableTypeNode.this.getValue();
                Structure structure = null;
                if (dataValue3 != null && !dataValue3.isNull() && (object = dataValue3.getValue().getValue()) instanceof Structure) {
                    structure = (Structure)object;
                }
                if (structure == null) {
                    try {
                        structure = structureSpecification.toStructureBuilder().build();
                    }
                    catch (Exception exception) {
                        logger.error("Failed to instantiate new Structure, ignoring datachanges in lower nodes", (Throwable)exception);
                        return;
                    }
                }
                if (!(structure instanceof Cloneable)) {
                    logger.error("The current Structure cannot be cloned");
                    return;
                }
                try {
                    Object object2;
                    object = structure.clone();
                    if (dataValue2 == null || dataValue2.isNull()) {
                        object.set(fieldSpecification, null);
                    } else {
                        object2 = dataValue2.getValue().getValue();
                        if (Enumeration.class.isAssignableFrom(fieldSpecification.getJavaClass()) && object2 instanceof Integer) {
                            EnumerationSpecification enumerationSpecification = BaseVariableTypeNode.this.getNodeManager().getNodeManagerTable().getEncoderContext().getEnumerationSpecification(fieldSpecification.getDataTypeId());
                            if (enumerationSpecification == null) {
                                logger.warn("Cannot get EnumerationSpecification for DataTypeId: {}, skipping sub-node generation", (Object)fieldSpecification.getDataTypeId());
                                return;
                            }
                            object.set(fieldSpecification, enumerationSpecification.toEnumerationBuilder().setValue((Integer)object2).build());
                        } else {
                            object.set(fieldSpecification, object2);
                        }
                    }
                    object2 = dataValue2.clone();
                    ((DataValue)object2).setValue(new Variant(object));
                    BaseVariableTypeNode.this.setValue((DataValue)object2);
                }
                catch (Exception exception) {
                    logger.error("Could not set new Structure value", (Throwable)exception);
                    return;
                }
            }
        });
    }
}

