/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditConditionAcknowledgeEventType;
import com.prosysopc.ua.types.opcua.server.AuditConditionAcknowledgeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditConditionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8944")
public abstract class AuditConditionAcknowledgeEventTypeNodeBase
extends AuditConditionEventTypeNode
implements AuditConditionAcknowledgeEventType {
    private static GeneratedNodeInitializer<AuditConditionAcknowledgeEventTypeNode> Cd;

    protected AuditConditionAcknowledgeEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditConditionAcknowledgeEventTypeNode> generatedNodeInitializer = AuditConditionAcknowledgeEventTypeNodeBase.getAuditConditionAcknowledgeEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditConditionAcknowledgeEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditConditionAcknowledgeEventTypeNode> getAuditConditionAcknowledgeEventTypeNodeInitializer() {
        return Cd;
    }

    public static void setAuditConditionAcknowledgeEventTypeNodeInitializer(GeneratedNodeInitializer<AuditConditionAcknowledgeEventTypeNode> generatedNodeInitializer) {
        Cd = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getConditionEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionEventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getConditionEventId() {
        UaProperty uaProperty = this.getConditionEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConditionEventId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setConditionEventId(ByteString byteString) {
        UaProperty uaProperty = this.getConditionEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionEventId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionEventId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Comment");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getComment() {
        UaProperty uaProperty = this.getCommentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Comment does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setComment(LocalizedText localizedText) {
        UaProperty uaProperty = this.getCommentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Comment failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Comment failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

