/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.UadpDataSetMessageContentMask;
import com.prosysopc.ua.stack.core.UadpNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.UadpDataSetReaderMessageType;
import com.prosysopc.ua.types.opcua.client.DataSetReaderMessageTypeImpl;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21116")
public abstract class UadpDataSetReaderMessageTypeImplBase
extends DataSetReaderMessageTypeImpl
implements UadpDataSetReaderMessageType {
    protected UadpDataSetReaderMessageTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getNetworkMessageNumber() {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageNumber(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageNumber failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getPublishingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getPublishingInterval() {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setPublishingInterval(Double d2) throws StatusException {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishingInterval failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpDataSetMessageContentMask getDataSetMessageContentMask() {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpDataSetMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetMessageContentMask(UadpDataSetMessageContentMask uadpDataSetMessageContentMask) throws StatusException {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(uadpDataSetMessageContentMask);
    }

    @Override
    @Mandatory
    public UaProperty getReceiveOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReceiveOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getReceiveOffset() {
        UaProperty uaProperty = this.getReceiveOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setReceiveOffset(Double d2) throws StatusException {
        UaProperty uaProperty = this.getReceiveOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReceiveOffset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getProcessingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProcessingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getProcessingOffset() {
        UaProperty uaProperty = this.getProcessingOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setProcessingOffset(Double d2) throws StatusException {
        UaProperty uaProperty = this.getProcessingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProcessingOffset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getGroupVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getGroupVersion() {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setGroupVersion(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupVersion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask uadpNetworkMessageContentMask) throws StatusException {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(uadpNetworkMessageContentMask);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetOffset() {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetOffset(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetOffset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UUID getDataSetClassId() {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UUID)object;
    }

    @Override
    @Mandatory
    public void setDataSetClassId(UUID uUID) throws StatusException {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetClassId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(uUID);
    }
}

