/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.StateVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8995")
public abstract class TwoStateVariableTypeImplBase
extends StateVariableTypeImpl
implements TwoStateVariableType {
    protected TwoStateVariableTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getFalseStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FalseState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getFalseState() {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setFalseState(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FalseState failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Optional
    public UaProperty getEffectiveTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveTransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEffectiveTransitionTime() {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEffectiveTransitionTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaProperty getTrueStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrueState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getTrueState() {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setTrueState(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrueState failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isId() {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setId(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTransitionTime() {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTransitionTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }
}

