/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12522")
public abstract class TrustListTypeImplBase
extends FileTypeImpl
implements TrustListType {
    protected TrustListTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getUpdateFrequencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateFrequency");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getUpdateFrequency() {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setUpdateFrequency(Double d2) throws StatusException {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdateFrequency failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaMethod getRemoveCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void removeCertificate(String string, Boolean bl) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"));
        this.call(nodeId, string, bl);
    }

    public AsyncResult<Void> removeCertificateAsync(String string, Boolean bl) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, string, bl);
    }

    @Override
    @Optional
    public UaMethod getCloseAndUpdateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public Boolean closeAndUpdate(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"));
        return this.call(nodeId, new MethodArgumentTransformer<Boolean>(){

            public Boolean e(Variant[] variantArray) {
                return (Boolean)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.e(variantArray);
            }
        }, unsignedInteger);
    }

    public AsyncResult<? extends Boolean> closeAndUpdateAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Boolean>(){

            public Boolean e(Variant[] variantArray) {
                return (Boolean)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.e(variantArray);
            }
        }, unsignedInteger);
    }

    @Override
    @Optional
    public UaMethod getAddCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void addCertificate(ByteString byteString, Boolean bl) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"));
        this.call(nodeId, byteString, bl);
    }

    public AsyncResult<Void> addCertificateAsync(ByteString byteString, Boolean bl) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, byteString, bl);
    }

    @Override
    @Mandatory
    public UaMethod getOpenWithMasksNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public UnsignedInteger openWithMasks(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"));
        return this.call(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger t(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.t(variantArray);
            }
        }, unsignedInteger);
    }

    public AsyncResult<? extends UnsignedInteger> openWithMasksAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger t(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.t(variantArray);
            }
        }, unsignedInteger);
    }
}

