/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.OperationLimitsType;
import com.prosysopc.ua.types.opcua.RoleSetType;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.ServerVendorCapabilityType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import java.util.List;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2013")
public abstract class ServerCapabilitiesTypeImplBase
extends BaseObjectTypeImpl
implements ServerCapabilitiesType {
    protected ServerCapabilitiesTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getLocaleIdArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIdArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIdArray() {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIdArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocaleIdArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getServerProfileArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerProfileArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerProfileArray() {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerProfileArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerProfileArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareCertificatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareCertificates");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SignedSoftwareCertificate[])object;
    }

    @Override
    @Mandatory
    public void setSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) throws StatusException {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareCertificates failed, the Optional node does not exist)");
        }
        uaProperty.setValue(signedSoftwareCertificateArray);
    }

    @Override
    @Mandatory
    public UaProperty getMaxHistoryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxHistoryContinuationPoints() {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getMinSupportedSampleRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinSupportedSampleRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMinSupportedSampleRate() {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMinSupportedSampleRate(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getMaxBrowseContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxBrowseContinuationPoints() {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Optional
    public UaProperty getMaxArrayLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxArrayLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxArrayLength() {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxArrayLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxArrayLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxByteStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxByteStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxByteStringLength() {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxByteStringLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxByteStringLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getMaxQueryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxQueryContinuationPoints() {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Optional
    public UaProperty getMaxStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxStringLength() {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxStringLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxStringLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    public List<? extends ServerVendorCapabilityType> getVendorCapability_PlaceholderNodes() {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11562");
        ExpandedNodeId expandedNodeId2 = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=47");
        return this.findPlaceholders(ServerVendorCapabilityType.class, expandedNodeId, expandedNodeId2);
    }

    @Override
    @Mandatory
    public FolderType getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public FolderType getModellingRulesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModellingRules");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public OperationLimitsType getOperationLimitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperationLimits");
        return (OperationLimitsType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public RoleSetType getRoleSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RoleSet");
        return (RoleSetType)this.getComponent(qualifiedName);
    }
}

