/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DiagnosticsLevel;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsCounterType;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19677")
public abstract class PubSubDiagnosticsTypeImplBase
extends BaseObjectTypeImpl
implements PubSubDiagnosticsType {
    protected PubSubDiagnosticsTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterType getTotalInformationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalInformation");
        return (PubSubDiagnosticsCounterType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTotalInformation() {
        PubSubDiagnosticsCounterType pubSubDiagnosticsCounterType = this.getTotalInformationNode();
        if (pubSubDiagnosticsCounterType == null) {
            return null;
        }
        Object object = pubSubDiagnosticsCounterType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTotalInformation(UnsignedInteger unsignedInteger) throws StatusException {
        PubSubDiagnosticsCounterType pubSubDiagnosticsCounterType = this.getTotalInformationNode();
        if (pubSubDiagnosticsCounterType == null) {
            throw new RuntimeException("Setting TotalInformation failed, the Optional node does not exist)");
        }
        pubSubDiagnosticsCounterType.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSubErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubError");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isSubError() {
        BaseDataVariableType baseDataVariableType = this.getSubErrorNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setSubError(Boolean bl) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSubErrorNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SubError failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(bl);
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterType getTotalErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalError");
        return (PubSubDiagnosticsCounterType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTotalError() {
        PubSubDiagnosticsCounterType pubSubDiagnosticsCounterType = this.getTotalErrorNode();
        if (pubSubDiagnosticsCounterType == null) {
            return null;
        }
        Object object = pubSubDiagnosticsCounterType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTotalError(UnsignedInteger unsignedInteger) throws StatusException {
        PubSubDiagnosticsCounterType pubSubDiagnosticsCounterType = this.getTotalErrorNode();
        if (pubSubDiagnosticsCounterType == null) {
            throw new RuntimeException("Setting TotalError failed, the Optional node does not exist)");
        }
        pubSubDiagnosticsCounterType.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getDiagnosticsLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiagnosticsLevel");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DiagnosticsLevel getDiagnosticsLevel() {
        BaseDataVariableType baseDataVariableType = this.getDiagnosticsLevelNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (DiagnosticsLevel)variant.asEnum(DiagnosticsLevel.class);
    }

    @Override
    @Mandatory
    public void setDiagnosticsLevel(DiagnosticsLevel diagnosticsLevel) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getDiagnosticsLevelNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting DiagnosticsLevel failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(diagnosticsLevel);
    }

    @Override
    @Mandatory
    public BaseObjectType getLiveValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LiveValues");
        return (BaseObjectType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BaseObjectType getCountersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Counters");
        return (BaseObjectType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UaMethod getResetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void reset() throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"));
        this.call(nodeId, new Object[0]);
    }

    public AsyncResult<Void> resetAsync() {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, new Object[0]);
    }
}

