/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.NonExclusiveDeviationAlarmType;
import com.prosysopc.ua.types.opcua.client.NonExclusiveLimitAlarmTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=10368")
public abstract class NonExclusiveDeviationAlarmTypeImplBase
extends NonExclusiveLimitAlarmTypeImpl
implements NonExclusiveDeviationAlarmType {
    protected NonExclusiveDeviationAlarmTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSetpointNode() {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSetpointNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SetpointNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Optional
    public UaProperty getBaseSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseSetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getBaseSetpointNode() {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setBaseSetpointNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseSetpointNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

